PRO gui_mapper::event_listener, event
    @map_pars

    ; check associated mapper has not been destroyed
    if (not obj_valid(self.mapper)) then begin
        message,'ERROR: INVALID ASSOCIATED MAPPER OBJECT'
        return
    endif

    if (event.id eq self.actions_wid) then begin

        case event.value of

             ; ATLANTIC BUTTON
             0: begin 
                  self->set_map_limits, [-90, -180, 90, 180]
                  self->set_map_center, [0, 0] 
                  self->set_map_projection, MAP_CYLINDRICAL
                  self->set_map_flags,[0,1]
                end      

             ; PACIFIC BUTTON
             1: begin 
                  self->set_map_limits, [-90, 0, 90, 360]
                  self->set_map_center, [0, 180]
                  self->set_map_projection, MAP_CYLINDRICAL
                  self->set_map_flags,[0,1]
                end

             ; NORTH POLE BUTTON
             2: begin  
                  if (self.map_system eq MAP_SYSTEM_POSITIVE) then $
                       self->set_map_limits, [-90,    0, 90, 360]  $
                  else self->set_map_limits, [-90, -180, 90, 180]
                  self->set_map_center, [90, 0]
                  self->set_map_projection, MAP_ORTHOGRAPHIC
                  self->set_map_flags,[1,0]
                end

             ; SOUTH POLE BUTTON
             3: begin 
                  if (self.map_system eq MAP_SYSTEM_POSITIVE) then $
                       self->set_map_limits, [-90,    0, 90, 360]  $
                  else self->set_map_limits, [-90, -180, 90, 180]
                  self->set_map_center, [-90, 0]
                  self->set_map_projection, MAP_ORTHOGRAPHIC
                  self->set_map_flags,[1,0]
                end

             ; SET BUTTON
             4: begin 
                 ; do nothing more
                end

             ; QUIT BUTTON
             5: begin
                  obj_destroy, self
                  return
                end

        endcase

    endif

    ; PROJECTION WIDGET
    error = self->export()                  ; export parameters to mapper
    if (error eq 0) then self.mapper->map   ; call mapper main method

END
