; program called by Xmanager when an event is generated by a gui object
; calls back event listener of gui subclass
PRO gui_event_listener, event

   ; traps all error generated by this widget's events
   catch, error_status
   ;error_status=0
   if (error_status eq 0) then begin

     widget_control, event.id, get_uvalue=uvalue

     if (obj_valid(uvalue)) then begin

       ; determine which event type
       event_name = strlowcase(tag_names(event, /structure_name))

       ; WINDOW CLOSED EVENT
       if (event_name eq 'widget_kill_request') then begin
          obj_destroy, uvalue
       endif else begin
          uvalue->event_listener,event
       endelse

     endif

   endif else begin
      result = dialog_message(['ERROR:',!err_string])
   endelse

END

