; Method used to set the title of the gui window
; method to set title
pro gui::set_title, title
    self.windowtitle = title
    widget_control, (self->get_base()), tlb_set_title=title
end

; Method used to get the title of the gui window
; method to get title
function gui::get_title, title
    return, self.windowtitle
end

;mgs++
;  04/04/2002: added registername keyword (used by archive manager and
;  plotter)
;  04/05/2002: added tlb_resize_events keyword (used by geov_plotter)
;mgs--
FUNCTION gui::INIT, title=title, group_leader=group_leader, column=column, row=row, $
                    floating=floating, kbrd_focus_events=kbrd_focus_events, mbar=mbar, $
                    xoffset=xoffset, yoffset=yoffset, registername=registername, $
                    tlb_size_events=tlb_size_events

  ; build main base
  if (keyword_set(mbar)) then begin
    self.base_wid = widget_base(title=title,                         $
                                group_leader=group_leader,           $
                                /tlb_kill_request_events,            $ ; return events if widget is closed
                                kbrd_focus_events=kbrd_focus_events, $ ; return events when focus changes
                                tlb_size_events=keyword_set(tlb_size_events), $
                                mbar=mbar,                           $
                                uvalue=self,                         $
                                floating=floating,                   $
                                resource_name='my_gui',              $
                                rname_mbar='my_bar',               $
                                column=column, row=row,xoffset=xoffset,yoffset=yoffset)
    ; call subclass method to build gui
    self->build_gui, mbar=mbar
  endif else begin
    self.base_wid = widget_base(title=title,                         $
                                group_leader=group_leader,           $
                                /tlb_kill_request_events,            $ ; return events if widget is closed
                                kbrd_focus_events=kbrd_focus_events, $ ; return events when focus changes
                                tlb_size_events=keyword_set(tlb_size_events), $
                                uvalue=self,                         $
                                floating=floating,                   $
                                resource_name='my_gui',              $
                                column=column, row=row,xoffset=xoffset,yoffset=yoffset)
    ; call subclass method to build gui
    self->build_gui
  endelse


  ; realize widget
  widget_control, self.base_wid, /realize


  ; Positioning of the base widget in the linux environment does not
  ; seem to work.  The program hangs until the user manually positions
  ; the window.  Hence, we will not attemp to position the base widget
  ; in the linux environment.

;  if ( STRCMP(!VERSION.OS , 'linux',5,/fold_case) eq 0) then begin
  if ( STRCMP(!VERSION.OS_FAMILY , 'unix',4,/fold_case) eq 0) then begin
    ; position gui (either with given offsets or in the center of the screen)
    gui_geometry = widget_info(self.base_wid, /geometry)
    screen_size = get_screen_size()

    if (n_elements(xoffset) gt 0) then $
       widget_control, self.base_wid, tlb_set_xoffset=xoffset $
    else $
       widget_control, self.base_wid, tlb_set_xoffset=0.5*(screen_size[0]-gui_geometry.scr_xsize)
    if (n_elements(yoffset) gt 0) then $
       widget_control, self.base_wid, tlb_set_yoffset=yoffset $
    else $
       widget_control, self.base_wid, tlb_set_yoffset=0.5*(screen_size[1]-gui_geometry.scr_ysize)
  endif


  ; register with xmanager
;mgs++
  IF n_elements(registername) EQ 0 THEN registername = 'gui::INIT'
  xmanager, registername, self.base_wid, EVENT_HANDLER='gui_event_listener', /no_block
;mgs--
  return, 1
END
