FUNCTION color_manager::get_color_table
  return, self.color_table
END
PRO color_manager::set_color_table, ct
  self.color_table = ct
END
FUNCTION color_manager::get_black
  return, 0 ; since black is ALWAYS loaded at position 0
END
FUNCTION color_manager::get_white
  return, !d.table_size-1 ; since white is ALWAYS loaded at last position
END

PRO color_manager__define
    struct = { color_manager,             $ ; class name
               color_table:0L,            $ ; color table index: >=0 for IDL tables, <0 for my tables

               myncolors:0B,              $ ; number of preset colors available for selection if color_table<0
               mycolors:ptr_new(),        $ ; preset colors available for selection
               black:0B,                  $ ; indexes of preset colors identified by name
               dark_red:0B,brown:0B,      $
               red:0B,                    $
               dark_green:0B,             $
               dark_yellow:0B, olive:0B,  $
               red_yellow:0B, orange:0B,  $
               green:0B,                  $
               green_yellow:0B, lime:0B,  $
               yellow:0B,                 $
               dark_blue:0B, navy:0B,     $ 
               dark_magenta:0B, purple:0B,$
               red_magenta:0B,            $
               dark_cyan:0B, teal:0B,     $
               gray:0B,                   $
               light_red:0B, pink:0B,     $
               green_cyan:0B,             $
               light_green:0B,            $
               light_yellow:0B,           $
               blue:0B,                   $
               blue_magenta:0B,           $
               magenta:0B,                $
               blue_cyan:0B,              $
               light_blue:0B,             $
               light_magenta:0B,          $
               cyan:0B,                   $
               light_cyan:0B,             $
               white:0B,                  $
               dark_gray:0B,              $
               light_gray:0B,             $
               light_violet:0B,           $
               violet:0B,                 $
               dark_violet:0B,            $
               pea:0B,                    $
               mandarin:0B,               $
               light_reddish:0B,          $
               dark_reddish:0B            $
             }
END
