; list of personal data-storing directories (10 maximum)
; enter the directory names as indicated below, enclosing them within ' ',
; and incrementing the directory counter from 0 to 9
; UNIX example: data_dirs[n] = '/usr/yourname/data/ncdata'
; WINDOWS example: data_dirs[n] = 'C:\data\ncdata'
; ===========================
; This version distinguishes between a Unix and a Windows system and
; adds default directories pertaining to the MPI-Met local disks.
; The current working directory (from where geov was started) will
; always be listed first.

cd, current=curdir

data_dirs[0] = curdir
IF strcmp(!version.os_family ,'unix',4,/fold_case) THEN BEGIN
   theUser=getenv('USER')
   data_dirs[1] = '/home/'+theUser
   data_dirs[2] = ''
   data_dirs[3] = ''
ENDIF ELSE IF strcmp(!version.os_family, 'windows',3,/fold_case) THEN BEGIN
   data_dirs[1] = 'C:\data'
   data_dirs[2] = 'D:\'
   data_dirs[3] = ''
ENDIF ELSE BEGIN
   data_dirs[1] = ''
ENDELSE

; default window size (enter a pair of values indicating the fraction
; of the screen size, or the predefined strings 'tiny', 'small', 'medium',
; 'large', or 'huge')
;window_size = [ 0.5, 0.42 ]
window_size = 'medium'

; default position of plot within plot window
plot2d_position = [0.09, 0.1, 0.78, 0.84]
plot1d_position = [0.15, 0.1, 0.85, 0.85]
bar_position = [0.85, 0.1, 0.88, 0.9]

; default character size for plot axis and titles
charsize = 1.2

; default orientation for postscript output
ps_landscape = 1

; initial plot type (see geov/geov_pars.pro)
; good choices are: MAP, LATvsLON, LONaveLEVvsVAR_TITLE (zonal mean)
; default: LATvsLON
plot_type = MAP

; initial map type
; default: MAP
; map_type = MAP_AT

; initial contour option (see geov/geov_pars.pro)
; good choices are: CONTOUR_OPT_LINES_MONO, CONTOUR_OPT_LINES_COLORED,
; CONTOUR_OPT_FILLED, CONTOUR_OPT_LINES_FILLED, CONTOUR_OPT_BOXES
; default: CONTOUR_OPT_LINES_FILLED
contour_opt = CONTOUR_OPT_FILLED

; date format (see IDL function LABEL_DATE)
; %Y (4-digit-year), %Z (2-digit-year), %M (month name, 3 letters),
; %N (2-digit-month), %D (2-digit-day), %W (day of week), %H (hour),
; %I (minute), %A (am/pm)
; default: '%D %M %Y  %H:%I UT'
; NB: - seconds are not resolved
;     - if time interval is > 27 days, the date label is always '%M %Y' with
;       full month name
;     - this format is also used for the time axis in 1D or 2D plots
dateformat = '%D%M%Y %H:%I'   ;; short and readable
; dateformat = '%W, %N/%D/%Z %H%A'   ;; american variant

; if the calendar is not specified in the netCDF file
; use this for the default calendar
; examples:
;    o  gregorian
;    o  365_days
default_calendar = 'gregorian'

; display or suppress warning messages (e.g. %compiled ...)
; set !QUIET to zero for debugging
!QUIET = 1

; set this to 0 if you don't want geov windows to be
; automatically brought to the top
auto_window_raise = 1
