Function compute_summation, parent

  widget_control, parent,get_uvalue=info

  coefstr = strtrim( (*info).coefs )

  indices = *((*info).selected_indices)

  if (indices[0]<0) then return, 1 ; ok -- no variables selected

  if ( strlen(coefstr) gt 0 ) then begin
    expr = 'coefs = [' + coefstr + '] '
    res = execute(expr,0)
    if (res eq 0) then begin
      x=dialog_message('Illegal coefficients', dialog_parent=parent ,/error)
      return, 0
    endif

    if ( n_elements(coefs) ne n_elements(indices) ) then begin
      x=dialog_message('Incorrect number of coefficients', dialog_parent=parent ,/error)
      return, 0
    endif

  endif else begin
    coefs = fltarr( n_elements(indices))
    coefs[*] = 1.0
  endelse

  gui = (*info).gui

  vunits = (gui->get_ncfiles())->get_vunits()
  pvars  = (gui->get_ncfiles())->get_pvars()   ; ids for plotting variables
  vids = (*pvars)[indices]
  units = (*vunits)[vids]

  for i=1, n_elements(units)-1 do begin
    if( units[i] ne units[i-1] ) then begin
;      x=dialog_message('The selected variables must have the same units', dialog_parent=parent ,/error)
      x=dialog_message('The selected variables do not have the same units', dialog_parent=parent )
      break
      ;return, 0
    endif
  endfor

  vnames = (gui->get_ncfiles())->get_vnames()
  name=''

  for j=0, n_elements(indices)-1 do begin

    ;extractor = obj_new('geov_extractor', gui, gui->get_ncfiles() )
    extractor = (gui->get_plotter())->get_extractor()

    extractor->set_var, indices[j]

    ; construct actions array for this plot
    extractor->make_actions, gui->get_ptype()

    ; extract data
    ok = extractor->extract_data(/simple)
    if (not ok) then return, 0

    data = extractor->get_data()

    vn = (*vnames)[(*pvars)[indices[j]]]
    pos = strpos( vn, '_' )
    if (pos ge 0 ) then vn = strmid( vn, 0, pos )
    if ( coefs[j] ne 1. ) then myname = strtrim(string(coefs[j]) + '*' + vn, 2) $
    else myname = strtrim( vn, 2)

    if (j lt 1) then begin
      sum = coefs[j]*(*data)
      name = myname
    endif else begin
      sum = sum + coefs[j]*(*data)
      name = name + ' + ' + myname
    endelse

    ;obj_destroy, extractor
    
    gui->set_ipvar,indices[0]

  endfor

;  name = name + ' [' + units[0] + ']'

  gui->set_dataname, name

  (*info).sum = ptr_new(sum, /no_copy)
  (*info).name = name

  return, 1
End


Pro operator_summation_event, event

  widget_control, event.top, get_uvalue=info

  case event.id of
    (*info).ok_wid:   	begin
                          indices = widget_info((*info).list_wid,/list_select)
                          if (ptr_valid((*info).selected_indices)) then ptr_free, (*info).selected_indices
                          (*info).selected_indices=ptr_new(indices)

                          widget_control, (*info).coefs_field, get_value=coefs
                          (*info).coefs = string( coefs[0] )

                          (*info).cancel = 0

                          ok = compute_summation( event.top )
                          if (ok) then begin
                            widget_control,event.top,/destroy
                          endif
                        end
    (*info).cancel_wid:	widget_control,event.top,/destroy
    else:
  endcase


End


Function operator_summation, gui, group_leader=group_leader, name=name, selected_flds=selected_flds, coefs=coefs, show=show

  ;create the summation dialog window

  topbase = widget_base( title='Summation Operator Selector', tlb_frame_att=3,/modal,$
                        group_leader=group_leader, /column )

  instr = widget_text( topbase,  value=['Select the variables to be summed by',$
                                        'holding down the control key while' , $
                                        'clicking the desired variables.  The',$
                                        'units of the selected variables must',$
                                        'be equal.'] , ysize=6)

  frame_wid = widget_base(topbase,/frame,/column)
  label_wid = widget_label(frame_wid,value='VARIABLES',/align_center)
  pvars = (gui->get_ncfiles())->get_pvars()
  vnames = (gui->get_ncfiles())->get_vnames()
  pnames = (*vnames)[ (*pvars) ]

  varlist = widget_list( frame_wid, /multiple, ysize=(20 < n_elements(pnames)), value=pnames, /align_center )

  if ( n_elements( selected_flds ) gt 0 ) then begin
    if ptr_valid(selected_flds) then begin
      widget_control, varlist, set_list_select = *selected_flds
    endif
  endif 

  rowbase = widget_base( topbase,/frame, /row)

  coefs_field = cw_field( rowbase, title='Enter coefficients seperated by comas', $
                        xsize=20, ysize=1, fieldfont=thisfont, font=thisfont ,/column  $
                        )
  if ( n_elements(coefs) gt 0 ) then begin
     widget_control, coefs_field, set_value=coefs
  endif

  rowbase = widget_base( topbase, /row)

  acceptid = widget_button( rowbase, value='OK' )

  cancelid = widget_button( rowbase, value='Cancel' )

  info = ptr_new({ list_wid:varlist, $
                   ;coef_wid:coefbut, $
                   coefs_field:coefs_field, $
                   ok_wid:acceptid, $
                   cancel_wid:cancelid, $
;                   coefs:'', $
;                   selected_indices:ptr_new(), $
                   coefs:coefs, $
                   selected_indices:selected_flds, $
                   sum:ptr_new(), $
                   cancel:1, $
                   name:'', $
                   gui:gui $
                })

  widget_control, topbase, set_uvalue=info ;, /no_copy

  if ( keyword_set( show ) ) then begin

    widget_control, topbase, default_button=acceptid, cancel_button=cancelid

    widget_control, topbase, /realize

    xmanager, 'operator_summation', topbase

  endif else begin
    ok = compute_summation( topbase )    
  endelse

  if ( keyword_set(show) and (*info).cancel ) then return, ptr_new() ; return null pointer

  sum_ptr = (*info).sum
  sum = ptr_new( *(sum_ptr) )
  name =   (*info).name

  if ( ptr_valid((*info).sum) ) then ptr_free, (*info).sum

  ;if ( ptr_valid((*info).selected_indices) ) then ptr_free, (*info).selected_indices
  selected_flds = (*info).selected_indices

  coefs = (*info).coefs
  ptr_free, info

  return, sum

End
