; method to take inverse of a given dataset
; data missing values must be substituted with !values.f_nan before calling this method
FUNCTION operator_inverse, ap

   ; allocate new memory
   bp = ptr_new(*ap)

   ; check for missing values
   ; and check for values where the inverse of zero gives an infinite result.
   good_indexes = where((finite(*ap) eq 1) and  (finite(1./*ap) eq 1), ngood)
   bad_indexes = where((finite(*ap) eq 0) or (finite(1./*ap) eq 0), nbad)
;   good_indexes = where(finite(*ap) eq 1 , ngood)
;   bad_indexes = where(finite(*ap) eq 0, nbad)

   if (ngood gt 0) then begin
       (*bp)[good_indexes] = 1./(*ap)[good_indexes]
   endif

   if (nbad gt 0) then (*bp)[bad_indexes] = !values.f_nan

   return, bp

END
