
function get_ilocations, old_xs,new_xs

oxs = float(old_xs)
nxs = float(new_xs)

indices = where( nxs ge min(oxs) and nxs le max(oxs)  , cnt )
if cnt eq 0 then return, -1

nxs = nxs[ indices ]

n = n_elements(nxs)
locs = fltarr(n)

for i=0,n-1 do begin
   j = (where( oxs eq  nxs[i], cnt ))[0]
   if cnt gt 0 then begin
      locs[i] = double(j)
      continue
   end
   j = (where( oxs gt  nxs[i], cnt ))[0]
   if cnt eq 0 then return, locs[0:i-1]

   locs[i] = double(j-1) + (nxs[i] - oxs[j-1])/(oxs[j]-oxs[j-1])
endfor

return, locs

end


function operator_interp, data, old_xs=old_xs, old_ys=old_ys, old_zs=old_zs, $
                          new_xs=new_xs, new_ys=new_ys, new_zs=new_zs

dimensions = 0

if n_elements(new_xs) gt 0 then begin
   xs = get_ilocations(old_xs,new_xs) 
   dimensions = dimensions + 1
endif
if n_elements(new_ys) gt 0 then begin
   ys = get_ilocations(old_ys,new_ys) 
   dimensions = dimensions + 1
endif
if n_elements(new_zs) gt 0 then begin
   zs = get_ilocations(old_zs,new_zs) 
   dimensions = dimensions + 1
endif

if ( n_elements(xs) gt 0 ) then begin
   if ( n_elements(ys) gt 0 ) then begin
      if ( n_elements(zs) gt 0 ) then begin
         new_data = interpolate( data, xs, ys, zs, /grid ) 
      endif else begin
         new_data = interpolate( data, xs, ys, /grid ) 
      endelse
   endif else if ( n_elements(zs) gt 0 ) then begin
      new_data = interpolate( data, xs, zs, /grid ) 
   endif else begin
      new_data = interpolate( data, xs, /grid ) 
   endelse
endif else if ( n_elements(ys) gt 0 ) then begin
   if ( n_elements(zs) gt 0 ) then begin
      new_data = interpolate( data, ys, zs, /grid ) 
   endif else begin
      new_data = interpolate( data, ys, /grid ) 
   endelse
endif else if ( n_elements(zs) gt 0 ) then begin
   new_data = interpolate( data, zs, /grid ) 
endif else return, -1

dims = size(new_data,/dimensions)

if n_elements(dims) ne dimensions then return, -1
 
return, new_data

end


pro test_operator_interp

  data1 = findgen(4,4)

  xs1 = findgen(4)
  ys1 = findgen(4)
  
  xs2 = [-0.5,1.01,2.5,4.5]
  ys2 = findgen(3)+.5

print,'xs1 = ',xs1
print,'xs2 = ',xs2

print,'data1 = '
print, data1
  data2 = operator_interp( data1, old_xs=xs1, new_xs=xs2 , old_ys=ys1, new_ys=ys2 )
print,'data2 = '
print, data2

end

