; global method to check that two datasets (pointed by ap, bp) are compatible
FUNCTION operator_check, ap, bp, interpolate=interpolate

  ; check pointers are valid
  if ( (not ptr_valid(ap)) or (not ptr_valid(bp)) ) then return, 0

  ; check number of dimensions is the same
  da = size(*ap,/dimensions)
  db = size(*bp,/dimensions)
  if (n_elements(da) ne n_elements(db)) then return, 0

  ; check each dimension is the same
  for i=0, n_elements(da)-1 do begin
      if (da[i] ne db[i]) then begin
        if keyword_set(interpolate) then begin
          ; interpolate the data
        endif else begin
          return,0
        endelse
      endif
  endfor

  ; datasets are compatible
  return, 1

END
