; NOTE must perform computation in double precision 
FUNCTION hank_ncfile::get_xy, lat, lon

  ; rename coordinates
  phi = double(lat)
  lambda = double(lon)
  psi = 90.D - phi

  ; parameters
  pi = 2.D*asin(1.D)
  degran = pi/180.D
  a = 6370.D ; earth radius in km

  ; map center (x=0, y=0)
  lambda_0 = double(self.lon0)
  phi_0 = double(self.lat0)
  psi_0 = 90.D - phi_0  ; colatitude at center latitude

  CASE self.projection OF

    'Oblique_Stereographic': BEGIN

       ; true point
       phi_1 = 60.D 
       psi_1 = 90.D - phi_1

       ; constant factors
       c_1 = -lambda_0-90.D
       c_2 = a*sin(psi_1*degran)*( tan(0.5*psi_0*degran)/tan(0.5*psi_1*degran) )

       m = (1.+sin(phi_1*degran))/(1.+sin(phi*degran))
       r = a*m*cos(phi*degran)

       x = r*cos((lambda+c_1)*degran)
       y = r*sin((lambda+c_1)*degran) + c_2

       END

    'Lambert_Conformal': BEGIN

       n = 0.716D

       ; true point
       phi_1 = 60.D
       psi_1 = 90.D - phi_1

       ; constant factors
       c_1 = -lambda_0-90.D/n
       c_2 = (a/n)*sin(psi_1*degran)*((tan(0.5*psi_0*degran)/tan(0.5*psi_1*degran))^n)

       r = (a/n)*sin(psi_1*degran)*((tan(0.5*psi*degran)/tan(0.5*psi_1*degran))^n)

       x = r*cos(n*(lambda+c_1)*degran)
       y = r*sin(n*(lambda+c_1)*degran) + c_2

       END

    'Mercator': BEGIN

       ; true point
       phi_1 = 0.D

       x = a*cos(phi_1*degran)*(lambda-lambda_0)*degran
       y = a*cos(phi_1*degran)*alog( (1.D + sin(phi*degran) )/cos(phi*degran) )

      END

    ELSE: BEGIN
            print,'UNRECOGNIZED HANK PROJECTION:',self.projection
            stop
            END

  ENDCASE

  return, [x,y]

END
