; method overrides superclass method to manage hank file conversion
PRO hank_converter::event_listener, event

    if (event.id eq self.actions_wid) then begin

        ; CONVERSION action
        if (event.value eq 0) then begin

            ; retrieve all values from GUI
            widget_control, self.file_in_wid, get_value=ncfile_in
            widget_control, self.file_out_wid, get_value=ncfile_out
            widget_control, self.lat_wids[0], get_value=latmin
            widget_control, self.lat_wids[1], get_value=latmax
            widget_control, self.lat_wids[2], get_value=latdel
            widget_control, self.lon_wids[0], get_value=lonmin
            widget_control, self.lon_wids[1], get_value=lonmax
            widget_control, self.lon_wids[2], get_value=londel
            
            ; open input file
            ncfile = obj_new('hank_ncfile',ncfile_in[0])

            ; convert file
            widget_control,/hourglass
            ncfile->convert, ncfile_out[0], latmin, latmax, latdel, lonmin, lonmax, londel

            ; close input file
            obj_destroy, ncfile
            r = dialog_message('CONVERSION FINISHED')

        ; QUIT action
        endif else begin
            obj_destroy, self

        endelse

    endif else begin

      ; retrieve selected directory
      widget_control, event.id, get_value=dir
      ncfile_in = dialog_pickfile(title='Select netCDF file to convert', $
                                  path=dir, /must_exist)

      ; check that file exists and update widget
      if (ncfile_in ne '') then begin ; not CANCEL action
          check = findfile(ncfile_in,count=c)
          if (c gt 0) then begin
              ncfile_out = string(ncfile_in,'-ncgeo')
              widget_control, self.file_in_wid,set_value=ncfile_in
              widget_control, self.file_out_wid,set_value=ncfile_out
          endif
       endif

    endelse

END
