; method to compute new coordinate limits for plotting
; input: coordinate vertexes in IDL data coordinates
; (for maps, this means longitudes always range from -180 to 180)
FUNCTION geov_zoomer::zoom_box, lower_left_point, center_point, upper_right_point
    @geov_pars

    ;print,'lower_left_point=',lower_left_point
    ;print,'center_point=',center_point
    ;print,'upper_right_point=',upper_right_point

    ; indexes of coordinates on X, Y axis
    icx = self.plotter->get_xcoord_index()
    icy = self.plotter->get_ycoord_index()

    ; check points do not contain NaN
    indexes = where(finite([lower_left_point, center_point, upper_right_point]) eq 0, counts)
    if (counts gt 0) then begin
        print,string('INVALID ZOOMING LIMITS:', lower_left_point, center_point, upper_right_point)
        return, 1
    endif

    if (self.ismap) then begin

       ; convert points to map systems MAP_SYSTEM_POSITIVE or MAP_SYSTEM_NEGATIVE
       llp_ms = [self->convert_lon(lower_left_point[0],/to_map), lower_left_point[1]]
       cp_ms  = [self->convert_lon(center_point[0],/to_map), center_point[1]]
       urp_ms = [self->convert_lon(upper_right_point[0],/to_map), upper_right_point[1]]
       
       ; convert points to data system
       llp_ds = [self->convert_lon(lower_left_point[0],/to_data), lower_left_point[1]]
       cp_ds  = [self->convert_lon(center_point[0],/to_data), center_point[1]]
       urp_ds = [self->convert_lon(upper_right_point[0],/to_data), upper_right_point[1]]

    endif else begin

       ; points already in data system
       llp_ds = lower_left_point
       cp_ds = center_point
       urp_ds = upper_right_point

       ; convert points to map system
       llp_ms = [self->convert_lon(lower_left_point[0],/to_map), lower_left_point[1]]
       cp_ms  = [self->convert_lon(center_point[0],/to_map), center_point[1]]
       urp_ms = [self->convert_lon(upper_right_point[0],/to_map), upper_right_point[1]]

    endelse

    ;print,'llp_ds=',llp_ds 
    ;print,'cp_ds=',cp_ds 
    ;print,'urp_ds=',urp_ds 
    ;print,'llp_ms=',llp_ms
    ;print,'cp_ms=',cp_ms
    ;print,'urp_ms=',urp_ms

    ; order limits
    xcmin = min([llp_ds[0],urp_ds[0]], max=xcmax)
    ycmin = min([llp_ds[1],urp_ds[1]], max=ycmax)
    xccen = cp_ds[0] & yccen = cp_ds[1]

    ; special case: if center is not contained within minimum, maximum
    ; assign limits to full range
    if (xccen lt xcmin or xccen gt xcmax) then begin
        print,'INVERTED BOX, ASSIGN X LIMITS TO FULL RANGE'
        xcmin = self.cminima[icx,0]
        xcmax = self.cmaxima[icx,0]
    endif
 
    ; increment zoom counter, if possible, and keep track of previous zoom
    pzoom = self.izoom
    max_zooms = n_elements(self.cminima[0,*])
    if (self.izoom lt max_zooms-1) then self.izoom = self.izoom+1
    
    ; assign new limits in data system
    for ic=0, 3 do begin
        CASE ic OF
             icx: BEGIN
                      ; assign new limits from X axis zooming
                      self.cminima[ic,self.izoom] = xcmin
                      self.cmaxima[ic,self.izoom] = xcmax
                    END
             icy: BEGIN
                      ; assign new limits from Y axis zooming
                      self.cminima[ic,self.izoom] = ycmin
                      self.cmaxima[ic,self.izoom] = ycmax
                    END
             else:  BEGIN
                      ; copy values from previous zoom
                      self.cminima[ic,self.izoom] = self.cminima[ic,pzoom] 
                      self.cmaxima[ic,self.izoom] = self.cmaxima[ic,pzoom]
                    END
        ENDCASE
    endfor

    ; assign new limits in map system
    CASE MYLON OF
         icx: BEGIN
                  self.map_limits[1,self.izoom] = llp_ms[0]
                  self.map_center[1,self.izoom] = cp_ms[0]
                  self.map_limits[3,self.izoom] = urp_ms[0]
                END
         icy: BEGIN
                  self.map_limits[1,self.izoom] = llp_ms[1]
                  self.map_center[1,self.izoom] = cp_ms[1]
                  self.map_limits[3,self.izoom] = urp_ms[1]
                END
         else: BEGIN
                  self.map_limits[1,self.izoom] = self.map_limits[1,pzoom]
                  self.map_center[1,self.izoom] = self.map_center[1,pzoom]
                  self.map_limits[3,self.izoom] = self.map_limits[3,pzoom]
               END
    ENDCASE
    CASE MYLAT OF
         icx: BEGIN
                  self.map_limits[0,self.izoom] = llp_ms[0]
                  self.map_center[0,self.izoom] = cp_ms[0]
                  self.map_limits[2,self.izoom] = urp_ms[0]
                END
         icy: BEGIN
                  self.map_limits[0,self.izoom] = llp_ms[1]
                  self.map_center[0,self.izoom] = cp_ms[1]
                  self.map_limits[2,self.izoom] = urp_ms[1]
                END
         else: BEGIN
                  self.map_limits[0,self.izoom] = self.map_limits[0,pzoom]
                  self.map_center[0,self.izoom] = self.map_center[0,pzoom]
                  self.map_limits[2,self.izoom] = self.map_limits[2,pzoom]
               END
    ENDCASE

    return, 0

END
