; method to initialize zoom=0 coordinate limits to full range inside file
PRO geov_zoomer::setup_limits, ncfiles
  @geov_pars

  p2coords=ncfiles->get_p2coords()

                                ; loop over coordinates for that file
  for ic=0, MAXCOORDS-1 do begin
      icf = p2coords[ic]        ; coordinate index in file
      if (icf ge 0) then begin
          values = ncfiles->get_coord(icf)


          if ptr_valid(values) then begin
              minvalue = min(*values,max=maxvalue)

              self.cminima[ic,0] = minvalue
              self.cmaxima[ic,0] = maxvalue

             ;self.cminima[ic,0] = values[0]
             ;self.cmaxima[ic,0] = values[n_elements(values)-1]
          endif
      endif
  endfor   ; loop over coordinates

  ; initialize map limits, center from coordinate limits
  self.map_limits[*,0] = [self.cminima[MYLAT,0], self.cminima[MYLON,0],$
                          self.cmaxima[MYLAT,0], self.cmaxima[MYLON,0] ]
  self.map_center[*,0] = [0.5*(self.cminima[MYLAT,0]+self.cmaxima[MYLAT,0]),$
                          0.5*(self.cminima[MYLON,0]+self.cmaxima[MYLON,0]) ]

END
