; function to convert longitudes to map and data systems
FUNCTION geov_zoomer::convert_lon, lons, to_map=to_map, to_data=to_data
  @geov_pars

  ; determine allowed coordinate range from zoom=0 map limits
  if (keyword_set(to_map)) then begin
      minlon = self.map_limits[1,0]
      maxlon = self.map_limits[3,0]

  ; determine allowed coordinate range from zoom=0 data limits
  endif else if (keyword_set(to_data)) then begin
      minlon = self.cminima[MYLON,0]
      maxlon = self.cmaxima[MYLON,0]
  endif

  ; convert longitudes out of allowed range
  if (minlon lt 0) then begin  ; range -180 to 180
      indexes = where(lons gt 180, counts)
      if (counts gt 0) then lons[indexes]=lons[indexes]-360.
  endif else if (maxlon gt 180) then begin  ; range 0 to 360
      indexes=where(lons lt 0., counts)
      if (counts gt 0) then lons[indexes]=lons[indexes]+360.
  endif

  return, lons
END
