FUNCTION geov_preferences::INIT
  @geov_pars

  ; initialize fields with default values
  window_size = 'medium'
  plot2d_position = [0.11, 0.1, 0.80, 0.84]
  plot1d_position = [0.15, 0.1, 0.85, 0.85]
  bar_position = [0.82, 0.1, 0.85, 0.9]
  charsize = 1.
  ps_landscape = 0
  plot_type = LATvsLON
  map_type = MAP       ;; default map; 0 = no map
  contour_opt = CONTOUR_OPT_LINES_FILLED
  dateformat = '%D %M %Y  %H:%I UT'   ;; example  '05 Sep 1994  00:00 UT'

  data_dirs = strarr(MAXDIRS)    ; arrays of user-defined data dirs
  data_dirs[*] = ''

  default_calendar = '365_days'

  ; overrides defaults with user-defined values from geov_preferences.pro (if found)
  @geov_preferences

  ; override defaults
  self.window_size = self->get_window_size(window_size)
  self.plot2d_position = plot2d_position
  self.plot1d_position = plot1d_position
  self.bar_position = bar_position
  self.charsize = charsize
  self.ps_landscape = ps_landscape
  self.plot_type = plot_type
  self.map_type = map_type
  self.contour_opt = contour_opt
  self.dateformat = dateformat
  self.default_calendar = default_calendar
  self.auto_win_raise = auto_window_raise

  ; count how many directories are valid
  ivalid = where(data_dirs ne '', nvalid)
  
  ; if no directories are found, start from current IDL working directory
  if (nvalid eq 0) then begin
      cd, current=current_dir
      self.data_dirs = ptr_new([current_dir])
  endif else begin
      self.data_dirs = ptr_new(data_dirs[ivalid])
  endelse

  return, 1
END

