FUNCTION geov_plotters_user::register_plotter, plotter

  ; check object is valid
  if (not obj_valid(plotter)) then return, -1 ; error

  ; first loop to see if object is registered already
  for ip=0,n_elements(self.plotters)-1 do begin
    if (obj_valid(self.plotters[ip])) then begin
      if (self.plotters[ip] eq plotter) then begin
           return, ip  ; return index
      endif
    endif
  endfor

  ; second loop to register new object in first empty slot
  for ip=0,n_elements(self.plotters)-1 do begin
    if (not obj_valid(self.plotters[ip])) then begin
        self.plotters[ip] = plotter; register
        return, ip  ; return index
    endif
  endfor

  print,'FAILED TO REGISTER PLOTTER'
  return, -1 ; error

END
