; NOTE: power operations must be done on double precision to work on windows with very small numbers...
FUNCTION set_levels, interval, zmin, zmax, max_levels, positive, negative, nzeros, levels, autolinear=autolinear, autolog=autolog, absmin=absmin
  @geov_pars
  EPSILON = 1.d-3

  if ( keyword_set(autolog) and keyword_set(autolinear) ) then begin
    Print, 'Conflicting keywords: autolinear, autolog'
    return, 1
  endif

  ; linear scaling
  if ( ((interval lt 1.2) and (not keyword_set(autolog))) or (keyword_set(autolinear)) ) then begin

      ; find interval separation
      delta = double(zmax-zmin)
      if (delta eq 0) then begin
          print,'WARNING in contour_manager::set_levels: modal field'
          if (positive eq 1) then levels = ptr_new([0.,zmax])  $
          else if (negative eq 1) then levels = ptr_new([-zmin,0.])
          return, 0
      endif
      if (delta ge 1.d) then begin
          i= -1
          while (delta gt 1.d) do begin
             delta = delta/10.d
             i = i+1 
          endwhile
      endif else begin
          i = 0
          while (delta lt 1.d) do begin
            delta = delta*10.d
            i = i+1
          endwhile
          i = -i
      endelse
      delta = 10.D^i 

      ; set number of divisions
      ndivisions = fix(double(zmax-zmin)/delta + 0.5)

      if (ndivisions gt max_levels) then begin
          while (ndivisions gt  max_levels) do begin
            delta = 2.d*delta
            ndivisions = fix(double(zmax-zmin)/delta + 0.5)
          endwhile
      endif else begin
          while (ndivisions le (max_levels/2 + 1)) do begin
                 if (ndivisions eq 1) then delta = 0.10d*delta $
            else if (ndivisions eq 2) then delta = 0.20d*delta $
            else if (ndivisions eq 3) then delta = 0.25d*delta $
            else                           delta = 0.50d*delta
            ndivisions = fix(double(zmax-zmin)/delta + 0.5)
          endwhile
      endelse
      if (ndivisions eq 0) then begin
          print,'ERROR in set_levels: ndivisions==0'
          return,-1
      endif

      while ( zmax/delta gt 32000.d ) do begin
        delta = delta*2.d
        ndivisions = fix((zmax-zmin)/delta + 0.5)
      endwhile

      ; determine top and bottom of scale
      if ((zmax mod delta) eq 0.) then top = double(zmax) $
      else top = (double(fix( double(zmax)/delta ))+1.d)*delta
      if ((zmin mod delta) eq 0.) then bot = double(zmin) $
      else bot = double(fix(zmin/delta))*delta

      ; shift bottom level so that bot le absmin  
      ; this is used to make all levels evenly spaced
      if ( n_elements(absmin) gt 0 ) then begin
        abstop = zmax+absmin
        while ( bot gt absmin ) do begin
          bot = bot-delta
          top = top-delta
        endwhile
        while ( (top-delta) ge abstop ) do begin
          top = top-delta
        endwhile
        while ( top lt abstop ) do begin
          top = top+delta
        endwhile
      endif

      ndivisions = fix( ( (1.d + EPSILON)*top-bot) /delta )

      ; assign levels
      maxlev = ndivisions+1
      ;minlev = max([maxlev-15,2])
      ; Rolando wants all linear levels to be evenly spaced 
      ; setting minlev = 2 forces this to happen
      minlev = 2

      nlevels = maxlev-minlev+2
      levels = ptr_new(dblarr(nlevels))
      if (positive eq 1) then begin
          if (nzeros eq 0) then (*levels)[0] = bot else (*levels)[0] = 0.
      endif else if (negative eq 1) then begin
          if (nzeros eq 0) then (*levels)[0] = -bot else (*levels)[0] = 0.
      endif

      for i=minlev, maxlev do begin
          if (positive eq 1) then begin
             (*levels)[i-minlev+1] = double( float(bot) + float(double(i-1)*delta) ) 
          endif else if (negative eq 1) then begin
             (*levels)[i-minlev+1] = -bot -double(i-1)*delta 
          endif 
      endfor

  ; logarithmic scaling
  endif else begin

    factor = double(max_levels)/interval
    
factor:
    if (factor lt 1.) then begin
        lfu = fix( ceil( alog10(zmax) ) )
        lstart = fix( floor( alog10(zmin) ) )
        ndivisions = lfu-lstart+1
        lfl = round(double(ndivisions+1)/double(max_levels) + 0.5)
        tmplevels = dblarr(MAXEDGES)
        tmplevels[0] = 10.D^lstart
        k=0
        while (tmplevels[k] lt zmax) do begin
           k = k+1
           if (k ge max_levels) then begin
               print,'ERROR in SETLEVELS: reached max_levels=',max_levels
               return, -1
           endif
           lstart = lstart+lfl
           tmplevels[k] = 10.D^lstart 
        endwhile
        levels = ptr_new(tmplevels[0:k])
        if (negative eq 1) then *levels = -(*levels)
    endif else begin
        ndivisions = floor(factor)
        if (ndivisions ge 5 and ndivisions lt 9) then ndivisions = 6 $
        else ndivisions = min([9,ndivisions])

        ; try "wing" divisions
        k = 0
        while (k lt 5) do begin
          k = k+1
          core_divs = floor(alog10(zmax)) - ceil(alog10(zmin)) + 1
          sdelta = 0.9/double(ndivisions)
          lstart = -( floor(alog10(zmin)) + 1)
          wing = zmin*10.D^lstart
          wing = wing mod 10.D^lstart
          if (wing ne 0.) then begin
              wing = 1.-wing
              wing = wing/sdelta
              wing_divs = max( [round(wing), 1] )
          endif else begin
              wing_divs = 0
          endelse
          lstart = -( floor(alog10(zmax)) + 1)
          wing = zmax*10.D^lstart
          if (wing ne 0.) then begin
              wing = wing/sdelta
              wing_divs = max( [round(wing), 1] ) + wing_divs
          endif
          tot_divs = core_divs*ndivisions+wing_divs
          if (tot_divs gt max_levels) then begin
              if (ndivisions eq 1) then begin
                  factor = 0.5
                  goto, factor
              endif
              ndivisions = ndivisions-1
              if (ndivisions eq 5) then ndivisions=4 $
              else if (ndivisions gt 6 and ndivisions lt 9) then ndivisions = 6 $
              else ndivisions = min([9, ndivisions])
          endif else begin
              goto,exitit
          endelse
        endwhile
exitit:
        sdelta = 9./double(ndivisions)
        ; set the lower boundary
        logfac = alog10(zmin)
        if (logfac lt 0.) then begin
           if (fix(logfac) ne logfac) then lfl = fix(logfac)-1 else lfl = fix(logfac)
        endif else begin
           if (fix(logfac) ne logfac) then lfl = fix(logfac) else lfl = fix(logfac)-1
        endelse
        lvl = 10.D^lfl
        delta = sdelta*lvl
        deltal = delta
        if (((zmin-lvl) mod delta) eq 0.) then bot = zmin $
        else bot = double(fix((zmin-lvl)/delta))*delta+lvl
        lstart = fix((bot-lvl)/delta)
        ; set the upper boundary
        logfac = alog10(zmax)
        if (logfac lt 0.) then begin
           if (fix(logfac) ne logfac) then lfu = fix(logfac)-1 else lfu = fix(logfac)
        endif else begin
           if (fix(logfac) ne logfac) then lfu = fix(logfac) else lfu = fix(logfac)-1
        endelse
        lvu = 10.D^lfu
        delta = sdelta*lvu
        if (((zmax-lvu) mod delta) eq 0.) then top = zmax $
        else top = (double(fix((zmax-lvu)/delta))+1.)*delta + lvu
        ustop = fix(((1.+EPSILON)*top -lvu)/delta)
        tmplevels = dblarr(MAXEDGES)
        k = -1
        for i=lfl,lfu do begin
           if (i eq lfl) then begin
               delta = deltal
               base = lvl
               jl = lstart
               ju = ndivisions
           endif else begin
               delta = 10.*delta
               base = 10.*base
               if (i eq lfu) then begin
                   jl = 1
                   ju = ustop
               endif else begin
                   jl = 1
                   ju = ndivisions
               endelse
           endelse
           for j=jl,ju do begin
               k = k+1
               tmplevels[k] = base + double(j)*delta
           endfor
        endfor

        maxlev = k
        minlev = max([maxlev-15,1])
        nlevels = maxlev-minlev+2
        levels = ptr_new(dblarr(nlevels))
        if (positive eq 1) then begin
            if (nzeros ne 0) then (*levels)[0] = 0. else (*levels)[0] = tmplevels[0]
        endif else if (negative eq 1) then begin
            if (nzeros ne 0) then (*levels)[0] = 0. else (*levels)[0] = -tmplevels[0]
        endif
        if (positive eq 1) then begin
            (*levels)[1:nlevels-1] = tmplevels[minlev:maxlev]
        endif else if (negative eq 1) then begin
            (*levels)[1:nlevels-1] = -tmplevels[minlev:maxlev]
        endif

    endelse  ; factor ge 1

  endelse ; logarithmic scaling

  ; invert levels
  if (negative eq 1) then *levels = reverse(*levels)
   
  return, 0

END
