; method to compute edges according to GUI values
FUNCTION geov_plotter_contour_manager::compute_edges
    @geov_pars

    ; retrieve user option
    widget_control, self.options_wid, get_value=option

    CASE option OF

         0: begin
             ; retrieve parameters
              widget_control, self.text_wids[0,0], get_value=slower
              lower = double(slower[0]) ; convert string to double precision number
              widget_control, self.text_wids[0,1], get_value=sdelta
              delta = double(sdelta[0]) ; convert string to double precision number
              widget_control, self.text_wids[0,2], get_value=nlevels
              if (delta le 0) then begin
                  status = dialog_message('ERROR: levels spacing must be > 0')
                  return, -1
              endif
              if (nlevels lt 1 or nlevels gt MAXEDGES) then begin
                  status = dialog_message(string('ERROR: Number of Levels must be >=1, <=',MAXEDGES))
                  return, -1
              endif
              ; set edges
              edges = ptr_new(dblarr(nlevels+1))
              for n=0, nlevels do (*edges)[n] = lower+delta*n
            end

         1: begin
              ; retrieve parameters
              widget_control, self.text_wids[1,0], get_value=slower
              lower = double(slower[0]) ; convert string to double precision number
              widget_control, self.text_wids[1,1], get_value=supper
              upper = double(supper[0]) ; convert string to double precision number
              widget_control, self.text_wids[1,2], get_value=nlevels
              if (lower ge upper) then begin
                  status = dialog_message('ERROR: lower edge must be < upper edge')
                  return, -1
              endif
              if (nlevels lt 1 or nlevels gt MAXEDGES) then begin
                  status = dialog_message(string('ERROR: Number of Levels must be >=1, <=',MAXEDGES))
                  return, -1
              endif
              ; set edges
              edges = ptr_new(dblarr(nlevels+1))
              delta = (upper-lower)/float(nlevels)
              for n=0, nlevels do (*edges)[n] = lower+delta*n
            end

         2: begin
              ; retrieve parameters
              widget_control, self.text_wids[2,0], get_value=slower
              lower = double(slower[0]) ; convert string to double precision number
              widget_control, self.text_wids[2,1], get_value=supper
              upper = double(supper[0]) ; convert string to double precision number
              widget_control, self.text_wids[2,2], get_value=nlevels
              if (lower ge upper) then begin
                  status = dialog_message('ERROR: lower edge must be < upper edge')
                  return, -1
              endif
              if (lower eq 0 or upper eq 0) then begin
                  status = dialog_message('ERROR: invalid edge=0 for logarithmic scale')
                  return, -1
              endif
              if (nlevels lt 1 or nlevels gt MAXEDGES) then begin
                  status = dialog_message(string('ERROR: Number of Levels must be >=1, <=',MAXEDGES))
                  return, -1
              endif
              if (lower gt 0) then begin
                  edges = ptr_new(dblarr(nlevels+1))
                  lgmin = alog10(double(lower))
                  lgmax = alog10(double(upper))
                  for n=0,nlevels do (*edges)[n] = 10.D^( lgmin + double(n)*(lgmax-lgmin)/double(nlevels) )
              endif else if (upper lt 0) then begin
                  edges = ptr_new(dblarr(nlevels+1))
                  lgmin = alog10(double(abs(lower)))
                  lgmax = alog10(double(abs(upper)))
                  for n=0,nlevels do (*edges)[n] = -10.D^( lgmin + double(n)*(lgmax-lgmin)/double(nlevels) )
              endif else if (lower lt 0 and upper gt 0) then begin
                  status = dialog_message('ERROR: logarithmic scale cannot span 0')
                  return, -1
              endif
            end

         3: begin
              ; retrieve parameters
              widget_control, self.text_wids[3,0], get_value=textarr
              thetext = textarr[0]
              widget_control, self.text_wids[3,1], get_value=thescalefactor
              ; replace potential ',' by blanks and compress string
              thetext = strcompress(strrepl(thetext,',',' '))
              
              self.usr_dfnd_lvls = thetext


              ; extract the inidividual numbers
              tokens = StrSplit(thetext,' ',/extract)
              ; convert to float
              edges = ptr_new(double(tokens))
              scalefactor = double(thescalefactor[0])
              (*edges)[*] = (*edges)[*] * scalefactor
              nlevels = n_elements(tokens)-1

              self.usr_scl_fctr = scalefactor

            end

         else: begin
                 status = dialog_message('ERROR: no scaling option selected')
                 return,-1
               end
    ENDCASE

    ; check
    for n=1, nlevels do begin
        if ( (*edges)[n] le (*edges)[n-1]) then begin
            status = dialog_message('ERROR: invalid edges')
            self->print
            ptr_free,edges
            return, -1
        endif
    endfor

    ; set new edges
    self->set_edges,*edges
    
    self.option = option
    ptr_free,edges

    return, 0

END
