; utility method to find index of array whose value best matches given value
FUNCTION geov_plotter::find_index, array, value
    it = -1 & min_distance = 1e10
    for i=0, n_elements(*array)-1 do begin
        distance = abs( (*array)[i]-value )
        if (distance lt min_distance) then begin
            min_distance = distance
            it = i
        endif
    endfor
    return, it
END

; method to select the indexes of xs, ys coordinate arrays
; closest to a specified point given in coordinate units
PRO geov_plotter::set_point, event_coords
  @geov_pars

  ; return immediately if user clicked on a 1D plot
  if (self.icx lt 0 or self.icy lt 0) then return

  ; match point to geov_plotter coordinates
  point_x = event_coords[0]
  point_y = event_coords[1]

  ix = self->find_index(self.xs, point_x)
  iy = self->find_index(self.ys, point_y)
  if (ix ge 0 and iy ge 0) then begin
      value = (*self.data)[ix,iy]
      themessage = string('X=',point_x,', Y=',point_y,',')
  endif

  ; loop over extractors and match point to file coordinates
  values = fltarr(n_elements(self.extractors))
  for ix=0, n_elements(self.extractors)-1 do begin
   if (obj_valid(self.extractors[ix])) then begin

    ; find corresoinding indexes in xs, ys arrays
    xs = (self.extractors[ix])->get_xs()
    ys = (self.extractors[ix])->get_ys()
    jx = self->find_index(xs,point_x)
    jy = self->find_index(ys,point_y)

    if (jx ge 0 and jy ge 0) then begin

        values[ix] = (*(self.extractors[ix]->get_data()))[jx,jy]

        ; update GUI and extractor
        CASE self.icx OF
             MYLAT: BEGIN
                      ((self.extractors[ix])->get_gui())->set_lat, jx
                      (self.extractors[ix])->set_lat, jx
                    END
             MYLON: BEGIN
                      ((self.extractors[ix])->get_gui())->set_lon, jx
                      (self.extractors[ix])->set_lon, jx
                    END
             MYLEV: BEGIN
                      ((self.extractors[ix])->get_gui())->set_lev, jx
                      (self.extractors[ix])->set_lev, jx
                    END
             MYTIM: BEGIN 
                      ((self.extractors[ix])->get_gui())->set_time, jx
                      (self.extractors[ix])->set_time, jx
                    END
        ENDCASE
        CASE self.icy OF
             MYLAT: BEGIN
                      ((self.extractors[ix])->get_gui())->set_lat, jy
                      (self.extractors[ix])->set_lat, jy
                    END
             MYLON: BEGIN 
                      ((self.extractors[ix])->get_gui())->set_lon, jy
                      (self.extractors[ix])->set_lon, jy
                    END
             MYLEV: BEGIN 
                      ((self.extractors[ix])->get_gui())->set_lev, jy
                      (self.extractors[ix])->set_lev, jy
                    END
             MYTIM: BEGIN
                      ((self.extractors[ix])->get_gui())->set_time, jy
                      (self.extractors[ix])->set_time, jy
                    END
        ENDCASE

    endif else begin
        value = !VALUES.F_NAN
    endelse

   endif ; extractor is valid
  endfor ; loop over extractors

  ; construct and print message
  themessage = themessage + ' VALUE: '
  if (self->is_binary(self.operator) eq 1) then begin
      ; must order the two datasets correctly...
      if (self.igui eq 0) then themessage = themessage + string(values[0]) +' op ' + string(values[1]) + ' = ' $
      else themessage = themessage + string(values[1]) + ' op ' + string(values[0]) + ' = '
  endif
  themessage = themessage + string(value)
  self->set_message,strcompress(themessage)

END
