PRO geov_plotter::set_ptype, type
    @geov_pars

    self.ptype = type

    ; assign icx, icy
    pstruct = geov_get_bit_struct(type)

    if (pstruct.xbit eq LATBIT) then self.icx = MYLAT
    if (pstruct.xbit eq LONBIT) then self.icx = MYLON
    if (pstruct.xbit eq LEVBIT) then self.icx = MYLEV
    if (pstruct.xbit eq TIMBIT) then self.icx = MYTIM
    if (pstruct.xbit eq VARBIT) then self.icx = -1

    if (pstruct.ybit eq LATBIT) then self.icy = MYLAT
    if (pstruct.ybit eq LONBIT) then self.icy = MYLON
    if (pstruct.ybit eq LEVBIT) then self.icy = MYLEV
    if (pstruct.ybit eq TIMBIT) then self.icy = MYTIM
    if (pstruct.ybit eq VARBIT) then self.icy = -1

END

; mgs: added coption to remember typ eof contour level definition
PRO geov_plotter::set_edges, edges, overplot=overplot, coption=coption, usr_dfnd_lvls=usr_dfnd_lvls, usr_scl_fctr=usr_scl_fctr

    ; remember type
    IF n_elements(coption) GT 0 THEN self.coption = coption[0]
    IF n_elements(usr_dfnd_lvls) GT 0 THEN self.usr_dfnd_lvls = usr_dfnd_lvls[0]
    IF n_elements(usr_scl_lvls) GT 0 THEN self.usr_scl_fctr = usr_scl_fctr[0]

    ; convert edges to floats
    ; (since the contour procedure does that internally anyhow)
    fedges = ptr_new(float(*edges))

    ; check fedges for duplicates
    last = (*fedges)[0]
    for i=1, n_elements(*fedges)-1 do begin
        if (finite((*fedges)[i])) then begin
            if ( (*fedges)[i] le last) then begin
                 (*fedges)[i] = !values.F_NaN
            endif else begin
                 last = (*fedges)[i]
            endelse
        endif
    endfor

    ; disregard input edges which are +/-Inf
    indexes = where(finite(*fedges) eq 1, counts)

    ; allocate new memory
    newedges = ptr_new(fltarr(counts+2))

   ; bracket edges with +/- Inf   -- the +/- Inf levels seems to cause
   ;  problems with the contour routine on some platforms
    (*newedges)[0] = -!VALUES.F_INFINITY
    if (counts gt 0) then begin
        (*newedges)[1:counts] = (*fedges)[indexes]
    endif
    (*newedges)[counts+1] = +!VALUES.F_INFINITY

    ; set edges
    if (keyword_set(overplot)) then begin
       if (ptr_valid(self.oedges)) then ptr_free, self.oedges ; deallocate memory
       self.oedges = newedges
    endif else begin
       if (ptr_valid(self.edges)) then ptr_free, self.edges ; deallocate memory
       self.edges = newedges
    endelse

    ; free memory
    ptr_free, fedges
END

PRO geov_plotter::set_message, msg
    widget_control,self.status_bar_wid,set_value=msg
END

PRO geov_plotter::set_drawcolors, colornames
    self.drawcolors[1:*] = colornames
END

PRO geov_plotter::set_title, title
    self.title = title
END

PRO geov_plotter::set_xtitle, xtitle
    self.xtitle = xtitle
END

PRO geov_plotter::set_ytitle, ytitle
    self.ytitle = ytitle
END

PRO geov_plotter::set_datetime_info, val
    self.datetime_info = val
END

PRO geov_plotter::set_filename_info, val
    self.filename_info = val
END

PRO geov_plotter::set_auto_contour, boolean
    self.auto_contour = boolean
END

PRO geov_plotter::set_auto_log_linear, val
    self.auto_log_linear = val
END

PRO geov_plotter::set_smooth_width, val
    self.smooth_width = val
END

PRO geov_plotter::set_operator, op
    self.operator = op
END

PRO geov_plotter::set_extractor_type, ex
    self.extractor_type = ex
END

PRO geov_plotter::switch_levs2_flag
    if (self.levs2_flag eq 1) then self.levs2_flag = 0 else self.levs2_flag = 1
END

PRO geov_plotter::set_levs2_flag, val
    self.levs2_flag = val
END

PRO geov_plotter::switch_uvwind_flag
    self.uvwind_flag = 1 - self.uvwind_flag
END

PRO geov_plotter::set_oplot_samescale, selection
  self.oplot_samescale = selection
End

PRO geov_plotter::set_scaling, selection
  self.scaling = selection
  CASE selection OF
     0 : self.scale_factor = 1.
     1 : self.scale_factor = 1.e6  ;; VMR -> ppm
     2 : self.scale_factor = 1.e9  ;; VMR -> ppb
     3 : self.scale_factor = 1.e12 ;; VMR -> ppt
     4 : self.scale_factor = 0.    ;; must determine dynamically
  ENDCASE
END

PRO geov_plotter::set_contour_opt, opt
    self.contour_opt = opt
END

PRO geov_plotter::set_timeaxistype, type
    self.timeaxistype = type
END

PRO geov_plotter::set_scale_format, opt
    self.scale_format = opt
END

Pro geov_plotter::set_xyzrange,range,ixyz
    CASE ixyz OF
         0: self.xrange=range
         1: self.yrange=range
         2: self.zrange=range
      ELSE: print,'ERROR in geov_plotter::set_xyzrange ',ixyz
    ENDCASE
End

function geov_plotter::set_x_axis_labels
   @geov_pars
  common geov_plotter_timestamp_common, ncfiles, timescale, starttime

   ; reference to netCDF file
   ncfiles = (self->get_gui())->get_ncfiles()
   p2coords = ncfiles->get_p2coords()

    ; set function handling X axis labels
    xtickformat_function=''
    if (self.icx ge 0) then begin
      if (p2coords[self.icx] eq ncfiles->get_itim()) then begin
        case self.timeaxistype of

          RELATIVE: $
            begin
              xtickformat_function='geov_plotter_get_relativetime'

              ; set the time scale
              ; assume time is in days
              if      ((self.xrange[1]-self.xrange[0]) lt 1./24. ) then begin ; < 1 hours
                timescale=TIME_SCALE_SECS
              endif else begin
                if ((self.xrange[1]-self.xrange[0]) lt 2.0 ) then begin ; < 2 days
                  timescale=TIME_SCALE_HOUR
                endif else begin
                  timescale=TIME_SCALE_DAYS
                endelse
              endelse

              starttime = self.xrange[0]

              if ( timescale ne TIME_SCALE_NONE ) then begin
                self.xtitle = string( timescale, ' since ',  ncfiles->get_timestamp(self.xrange[0]))
              endif
            end

          ABSOLUTE: begin
                     starttime = self.xrange[0]
                     xtickformat_function='geov_plotter_get_timestamp'
                     self.xtitle=''
                    end

          Else:  print, 'unknown time axis type'

        endcase
      endif
    endif

    return, xtickformat_function
end


PRO geov_plotter::set
END
