;; mgs 20 April 2002:
;; - this routine contains a bug: (at least) occasionally, the data
;;   are extracted with a longitude shift (maybe also latitude??) by 1
;;   grid box. To verify this, load the test.nc file, which contains
;;   non-zero data in the 0..1 degree east grid box between 30 and 60
;;   N, then zoom into the data set in the boxes display on the
;;   Atlantic Map. In the no map display, extracting seems to work
;;   correctly.
;;       See also mgs debug output below: Apparently, what happens is
;;       that a column is added to the left of the data set, but the
;;       indices (xindexes) are computed without taking the extra
;;       column into account.

;; mgs (22 April 2002) : added wind vector overlay

; method to extract local copy of data arrays within zooming limits
PRO geov_plotter::plot2d_prepare_data, xs, ys, data, odata, $
                                       uwind=uwind, vwind=vwind, $
                                       ismap=ismap, oxs=oxs,oys=oys, success=success
   @geov_pars
   @nccoord_pars

   ; MAPS: retrieve map limits, center
   if (keyword_set(ismap)) then begin
       self.map_limits = self.zoomer->get_map_limits()
       self.map_center = self.zoomer->get_map_center()
   endif

   ; MAPS: add extra longitude column to arrays ?
   ; (note: assume longitudes are increasing...)
   added_left = 0  ;; mgs
   if (keyword_set(ismap) and grid_goes_around(self.xs,360.) eq 2) then begin

       if ( (*self.xs)[0] eq 0 or (*self.xs)[0] eq -180.) then begin
           ; add column to the right
           data2 = ptr_new([*self.data, (*self.data)[0,*]])
           xs2 = ptr_new([*self.xs, (*self.xs)[0]+360])
           ys2 = ptr_new(*self.ys)

;           if (self.operator eq OP_OVERPLOT) then $
           if (ptr_valid(self.odata)) then $
               odata2 = ptr_new([*self.odata, (*self.odata)[0,*]]) $
           else odata2 = ptr_new()

;           if (self.operator eq OP_OVERPLOT) then $
           if (ptr_valid(self.odata)) then $
               oxs2 = ptr_new([*self.oxs, (*self.oxs)[0]+360]) $
           else oxs2 = ptr_new()

;           if (self.operator eq OP_OVERPLOT) then $
           if (ptr_valid(self.odata)) then $
               oys2 = ptr_new(*self.oys) $
           else oys2 = ptr_new()

           IF ptr_valid(self.uwind) THEN $
              uwind2 = ptr_new([*self.uwind, (*self.uwind)[0,*]]) $
           ELSE uwind2 = ptr_new()
           IF ptr_valid(self.vwind) THEN $
              vwind2 = ptr_new([*self.vwind, (*self.vwind)[0,*]]) $
           ELSE vwind2 = ptr_new()
       endif else begin
           ; add column to the left
           nxs = n_elements(*self.xs)
           data2 = ptr_new([(*self.data)[nxs-1,*], *self.data])
           xs2 = ptr_new([*self.xs, (*self.xs)[nxs-1]-360])
           ys2 = ptr_new(*self.ys)

;           if (self.operator eq OP_OVERPLOT) then $
           if (ptr_valid(self.odata)) then $
               odata2 = ptr_new([(*self.odata)[nxs-1,*], *self.odata]) $
           else odata2 = ptr_new()

;           if (self.operator eq OP_OVERPLOT) then $
           if (ptr_valid(self.odata)) then $
               oxs2 =  ptr_new([*self.oxs, (*self.oxs)[nxs-1]-360]) $
           else oxs2 = ptr_new()

;           if (self.operator eq OP_OVERPLOT) then $
           if (ptr_valid(self.odata)) then $
               oys2 =  ptr_new(*self.oys) $
           else oys2 = ptr_new()

           IF ptr_valid(self.uwind) THEN $
              uwind2 = ptr_new([(*self.uwind)[nxs-1,*], *self.uwind]) $
           ELSE uwind2 = ptr_new()
           IF ptr_valid(self.vwind) THEN $
              vwind2 = ptr_new([(*self.vwind)[nxs-1,*], *self.vwind]) $
           ELSE vwind2 = ptr_new()
           added_left = 1    ;; mgs
       endelse

   endif else begin

       ; local copy of arrays
       data2 = ptr_new(*self.data)
       xs2 = ptr_new(*self.xs)
       ys2 = ptr_new(*self.ys)
;       if (self.operator eq OP_OVERPLOT) then $
       if (ptr_valid(self.odata)) then $
            odata2 = ptr_new(*self.odata) $
       else odata2 = ptr_new()

;       if (self.operator eq OP_OVERPLOT) then $
       if (ptr_valid(self.odata)) then $
            oxs2 = ptr_new(*self.oxs) $
       else oxs2 = ptr_new()
;       if (self.operator eq OP_OVERPLOT) then $
       if (ptr_valid(self.odata)) then $
            oys2 = ptr_new(*self.oys) $
       else oys2 = ptr_new()

       IF ptr_valid(self.uwind) THEN $
          uwind2 = ptr_new(*self.uwind) $
       ELSE uwind2 = ptr_new()
       IF ptr_valid(self.vwind) THEN $
              vwind2 = ptr_new(*self.vwind) $
       ELSE vwind2 = ptr_new()

   endelse

   ; MAPS: shift data (NOTE: assumes lons are ordered increasingly)
;; IS THIS PERHAPS WHERE THE ERROR OCCURS ?????
   if (keyword_set(ismap)) then begin
     if (self.map_limits[1] lt 0) then begin
       indexes = where(*xs2 gt 180., counts)
      if (counts gt 0) then begin
           *data2 = shift(*data2, counts, 0) ; shift to the right
           if ptr_valid(uwind2) then *uwind2=shift(*uwind2, counts, 0) ; shift to the right
           if ptr_valid(vwind2) then *vwind2=shift(*vwind2, counts, 0) ; shift to the right
           *xs2 = shift(*xs2,counts)
           (*xs2)[0:counts-1] = (*xs2)[0:counts-1]-360.
       endif
     endif else if (self.map_limits[3] gt 180) then begin
       indexes = where(*xs2 lt 0, counts)
       if (counts gt 0) then begin
           nxs2 = n_elements(*xs2)
           *data2 = shift(*data2,-counts,0) ; shift to the left
           if ptr_valid(uwind2) then *uwind2=shift(*uwind2,-counts, 0) ; shift to the right
           if ptr_valid(vwind2) then *vwind2=shift(*vwind2,-counts, 0) ; shift to the right
           *xs2 = shift(*xs2,-counts)
           (*xs2)[nxs2-counts:nxs2-1] = (*xs2)[nxs2-counts:nxs2-1]+360.
       endif
     endif
;     if (self.operator eq OP_OVERPLOT) then begin
     if (ptr_valid(self.odata)) then begin

       if (self.map_limits[1] lt 0) then begin
         indexes = where(*oxs2 gt 180., counts)
         if (counts gt 0) then begin
           *data2 = shift(*odata2, counts, 0) ; shift to the right
           *oxs2 = shift(*oxs2,counts)
           (*oxs2)[0:counts-1] = (*oxs2)[0:counts-1]-360.
         endif
       endif else if (self.map_limits[3] gt 180) then begin
         indexes = where(*oxs2 lt 0, counts)
         if (counts gt 0) then begin
           nxs2 = n_elements(*oxs2)
           *odata2 = shift(*odata2,-counts,0) ; shift to the left
           *oxs2 = shift(*oxs2,-counts)
           (*oxs2)[nxs2-counts:nxs2-1] = (*oxs2)[nxs2-counts:nxs2-1]+360.
         endif
       endif

     endif

   endif

   ; subset arrays to plotting region
   if (keyword_set(ismap)) then begin  ; MAP
       ; retrieve limits in map system
       ; note that shifted xs2, ys2 are compatible with map limits in current map system
       self.map_limits = self.zoomer->get_map_limits()
       self.map_center = self.zoomer->get_map_center()
       xcmin = self.map_limits[1]
       xcmax = self.map_limits[3]
       ycmin = self.map_limits[0]
       ycmax = self.map_limits[2]
   endif else begin  ; NO MAP
       ; retrieve limits in data system
       xlimits = self.zoomer->get_coord_limits(self.icx)
       ylimits = self.zoomer->get_coord_limits(self.icy)
       xcmin = xlimits[0]
       xcmax = xlimits[1]
       ycmin = ylimits[0]
       ycmax = ylimits[1]
   endelse

   xindexes = ptr_new(where( *xs2 ge xcmin and *xs2 le xcmax, xcounts ))
   yindexes = ptr_new(where( *ys2 ge ycmin and *ys2 le ycmax, ycounts ))

   if (ptr_valid(odata2)) then begin
      oxindexes = ptr_new(where( *oxs2 ge xcmin and *oxs2 le xcmax, xcounts ))
      oyindexes = ptr_new(where( *oys2 ge ycmin and *oys2 le ycmax, ycounts ))
   endif

   IF added_left THEN print,'*xindexes=',*xindexes      ;; mgs debugoutput

   success = 1

   ; check some data is contained within zooming region, if not unzoom back
   if (xcounts le 1 or ycounts le 1) then begin
       self.zoomer->unzoom ; zoom back
       success = 0
;;       message,string('ERROR IN SUBSETTING DATA ARRAYS, DEGENERATE ZOOMING REGION:')
       return
   endif

   data = ptr_new( ((*data2)[*xindexes,*])[*,*yindexes] )

   xs = ptr_new( (*xs2)[*xindexes] )
   ys = ptr_new( (*ys2)[*yindexes] )

   if (ptr_valid(odata2)) then begin
      odata = ptr_new( ((*odata2)[*oxindexes,*])[*,*oyindexes] )
      oxs = ptr_new( (*oxs2)[*oxindexes] )
      oys = ptr_new( (*oys2)[*oyindexes] )
   endif

   IF ptr_valid(uwind2) THEN uwind = ptr_new( ((*uwind2)[*xindexes,*])[*,*yindexes] )
   IF ptr_valid(vwind2) THEN vwind = ptr_new( ((*vwind2)[*xindexes,*])[*,*yindexes] )

   ; compute x,y minimum and maximum from data to be plotted
   xdmin = min(*xs, max=xdmax)
   ydmin = min(*ys, max=ydmax)
   self.xrange = [xdmin, xdmax]
   self.yrange = [ydmin, ydmax]
   ; possibly invert Y axis?
   if (self.icy eq MYLEV) then begin
       ncfiles = (self->get_gui())->get_ncfiles()
       if ( (ncfiles->is_cflag_set(ncfiles->get_ilev(),NCCOORD_FLAG_DOWN)) or  $
            (ncfiles->is_cflag_set(ncfiles->get_ilev(),NCCOORD_FLAG_PRESSURE)) ) then self.yrange = [ydmax, ydmin]
   endif
   ; check axis range
   if (self.xrange[0] eq self.xrange[1]) then self.xrange[0:1] = [self.xrange[0]-1.,self.xrange[0]+1]
   if (self.yrange[0] eq self.yrange[1]) then self.yrange[0:1] = [self.yrange[0]-1.,self.yrange[0]+1]

   ; ovveride map limits to fit data boundaries, but only if zoom>0
   if (self.zoomer->get_izoom() gt 0) then $
       self.map_limits = [ydmin, xdmin, ydmax, xdmax]

   ; compute minimum and maximum of partial data
   ;
   ; CGB get missing value from the file.
;   vnull = NULL_VALUE    ; data missing value
   vnull = ((self.extractors[self.igui]).ncfiles)->get_vnull((self.extractors[self.igui]).vid)
   self.zrange = self->compute_minmax(data, vnull)
   datamin = self.zrange[0]
   datamax = self.zrange[1]
   if (self.zrange[0] eq self.zrange[1]) then begin
       if (self.zrange[0] eq vnull) then message,'ERROR: NO VALID DATA IN RANGE' $
       else self.zrange[0:1] = [self.zrange[0]-1.,self.zrange[0]+1]
   endif
   self->set_message,string('DATA MINIMUM=',datamin,' MAXIMUM=',datamax)
   if (ptr_valid(odata)) then begin
       self->compute_edges, odata, vnull, /overplot
       self.orange = self->compute_minmax(odata, vnull)
   endif

   ; cleanup
   ptr_free, xindexes
   ptr_free, yindexes
   ptr_free,data2
   ptr_free,xs2
   ptr_free,ys2
   if (ptr_valid(odata2)) then ptr_free, odata2
   if (ptr_valid(uwind2)) then ptr_free, uwind2
   if (ptr_valid(vwind2)) then ptr_free, vwind2

   IF NOT ptr_valid(uwind) OR NOT ptr_valid(vwind) THEN self.uvwind_flag = 0

END

; method to setup coordinate transformation (for map or not)
PRO geov_plotter::plot2d_setup_view, xs, ys, data, ismap=ismap
    @geov_pars
    @map_pars

    ; mapping
    if (keyword_set(ismap)) then begin

       ; set map projection keywords
       ortho=0       & if (self.map_projection eq MAP_ORTHOGRAPHIC)  then ortho=1
       stereo=0      & if (self.map_projection eq MAP_STEREOGRAPHIC) then stereo=1
       gnomic=0      & if (self.map_projection eq MAP_GNOMIC)        then gnomic = 1
       azimuthal=0   & if (self.map_projection eq MAP_AZIMUTHAL)     then azimuthal=1
       aitoff=0      & if (self.map_projection eq MAP_AITOFF)        then aitoff=1
       lambert=0     & if (self.map_projection eq MAP_LAMBERT)       then lambert=1
       hammer=0      & if (self.map_projection eq MAP_HAMMER)        then hammer=1
       mercator=0    & if (self.map_projection eq MAP_MERCATOR)      then mercator=1
       transverse=0  & if (self.map_projection eq MAP_TRANSVERSE)    then transverse=1
       cylindrical=0 & if (self.map_projection eq MAP_CYLINDRICAL)   then cyl=1
       miller=0      & if (self.map_projection eq MAP_MILLER)        then miller=1
       conic=0       & if (self.map_projection eq MAP_CONIC)         then conic=1
       albers=0      & if (self.map_projection eq MAP_ALBERS)        then albers=1
       sinusoidal=0  & if (self.map_projection eq MAP_SINUSOIDAL)    then sinusoidal=1
       mollweide=0   & if (self.map_projection eq MAP_MOLLWEIDE)     then mollweide=1

       ;print,'mapset uses MAPLIMITS=',self.map_limits[*]
       ;print,'mapset uses MAPCENTER=',self.map_center[*]

       latcen = self.map_center[0]
       loncen = self.map_center[1]
       if (self.map_projection eq MAP_CYLINDRICAL) then latcen = 0. ; cylindrical projection special case
       if (self.map_flags[MAP_FLAG_ISOTROPIC] eq 1) then isotropic = 1 else isotropic = 0
       
       ; bug in IDL version 5.3 forces us to use this work-around
       defaultcolor=!p.color 
       !p.color=!D.Table_Size-COL_TITLES
       
       map_set, $
                latcen, loncen, $
                limit=self.map_limits, $
                ortho=ortho,                            $
                stereo=stereo,                          $
                gnomic=gnomic,                          $
                azimuthal=azimuthal,                    $
                aitoff=aitoff,                          $
                lambert=lambert,                        $
                hammer=hammer,                          $
                mercator=mercator,                      $
                transverse=transverse,                  $
                cyl=cyl,                                $
                miller=miller,                          $
                conic=conic,                            $
                albers=albers,                          $
                sinusoidal=sinusoidal,                  $
                mollweide=mollweide,                    $
                isotropic=isotropic, $
                position=self.plot2d_position, $
                title=self.title, $
                charsize=self.charsize, $
                color=!D.Table_Size-COL_TITLES, $
                /noborder

    !p.color = defaultcolor

    ; no mapping
    endif else BEGIN
       position=self.plot2d_position
       position[0]=position[0]+0.03
       position[2]=position[2]-0.03
       position[1]=position[1]+0.04
       self.plot2d_position=position
;; IF self.plot2d_position[1] LT 0.13 THEN self.plot2d_position[1]=0.13
       contour, *data, *xs, *ys, $
                xrange=self.xrange, xstyle=1, $
                yrange=self.yrange, ystyle=1, $
                zrange=self.zrange, zstyle=1, $
                xlog=self.xlog, ylog=self.ylog, $
                position=self.plot2d_position, $
                title=self.title, $
                charsize=self.charsize, $
                color=!D.Table_Size-COL_TITLES, $
                ticklen=0, $
                xtickformat='empty_string', ytickformat='empty_string', $
                min_value=NULL_VALUE, $
                /nodata
                                ;ticklen=-0.02, $  ; default ticklen, extended outward
    endelse

END

PRO geov_plotter::plot2d_draw_boxes, xs, ys, data, ismap=ismap

   ; determine x and y edges
   nx = n_elements(*xs)
   if ((*xs)[nx-1] lt (*xs)[nx-2]) then (*xs)[nx-1] = (*xs)[nx-1]+360.
   dx0 = (*xs)[1]-(*xs)[0]
   dx1 = (*xs)[nx-1]-(*xs)[nx-2]
   xedges = ( 0.5*((*xs)+shift((*xs),1)) )[1:*]  ; middle points
   xedges = [xedges[0]-dx0, xedges, xedges[nx-2]+dx1]
   xedges = (xedges<self.xrange[1]) > self.xrange[0]

   ny = n_elements(*ys)
   dy0 = (*ys)[1]-(*ys)[0]
   dy1 = (*ys)[ny-1]-(*ys)[ny-2]
   yedges = ( 0.5*((*ys)+shift((*ys),1)) )[1:*]
   yedges = [yedges[0]-dy0, yedges, yedges[ny-2]+dy1]
   ymin = min(self.yrange, max=ymax) ; NOTE: Y axis may be inverted...
   yedges = (yedges<ymax) > ymin

   ; limit edges to valid lat coordinates if data is on map
   if (keyword_set(ismap)) then begin
      yedges = ( yedges > (-90.) ) < 90.
   endif

   maxcolorindex = n_elements(*self.colors)-1

   ; draw a frame around boxes only if less than 30 boxes in x and y
   drawframe = (nx lt 30) and (ny lt 30)

   ; consider only finite edges
   findexes = where(finite(*self.edges) eq 1)
   fedges = (*self.edges)[findexes]

   ; loop through all X's and Y's and draw filled polygons
   for i=0L, nx-1 do begin
      for j=0L, ny-1 do begin
         ; Rectangle coordinates
         px = [ xedges[i], xedges[i+1], xedges[i+1], xedges[i], xedges[i] ]
         py = [ yedges[j], yedges[j], yedges[j+1], yedges[j+1], yedges[j] ]
         ; determine color value for this "pixel"
         belows = where(fedges le (*data)[i,j], counts)
         if (counts gt 0) then cind = findexes[belows[counts-1]] else cind = 0
         polyfill, px, py, color=(*self.colors)[cind]
         if (drawframe) then plots, px, py, color=0
      endfor
   endfor

END

PRO geov_plotter::plot2d_draw_contour, xs, ys, data, edges, colors, $
                                       ismap=ismap, filled=filled


    ; set labelling system
    c_labels = intarr(n_elements(edges))
    c_labels[*] = 0
    for i=1, n_elements(c_labels)-1, +3 do c_labels[i] = 1 ; label 1 every 3

    ; ?? - what if the limits of the edges extend beyond -9.99e30 and 9.99e30 ??

    ;; mgs: 20 April 2002
    ;; -Inf and Inf in edges leads to wrong colorbar; replace
    ;; temporarily with -9.99e30 and 9.99e30

    ; +/- Inf has been replace with the +/- max float given by machar()
    ;    -- see geov_plotter__set.pro

    myedges = edges
    ;myedges[0] = -9.99e30
    ;myedges[n_elements(edges)-1] = 9.99e30
    r = machar()
    myedges[0] = -r.xmax
    myedges[n_elements(edges)-1] = r.xmax


    contour,*data,*xs,*ys, $
            levels=myedges, $
;            levels=edges, $
            c_colors=colors, $
            c_labels=c_labels, $
            position=self.plot2d_position, $
            fill=filled*(1-ismap),cell_fill=filled*ismap, $
            min_value=NULL_VALUE, $
            /overplot

END

PRO geov_plotter::plot2d_overlayvector, xs, ys, uwind, vwind, color=color

   ; skip some vectors if too many (max 60 vectors along each dimension)
   maxvec = max([n_elements(*xs),n_elements(*ys)])
   reduce = long(maxvec/60)+1
   ix = lindgen(n_elements(*xs)/reduce+1)*reduce
   iy = lindgen(n_elements(*ys)/reduce+1)*reduce

   msvelovect, ((*uwind)[ix,*])[*,iy], ((*vwind)[ix,*])[*,iy], $
               (*xs)[ix], (*ys)[iy], color=color, /overplot

END

PRO geov_plotter::plot2d_draw_axis
   @geov_pars
   @nccoord_pars
   common geov_plotter_timestamp_common, ncfiles, timescale, starttime
   common pressure2altitude_common, pdata, zdata

   ; reference to netCDF file
   ncfiles = (self->get_gui())->get_ncfiles()
   p2coords = ncfiles->get_p2coords()

   ; set function handling X axis labels
   xtickformat_function=self->set_x_axis_labels()


   ; check if another Y axis must be drawn on the right
;mgs++
   hasvertical = (self.icy eq MYLEV)
   if hasvertical then begin
        if (ncfiles->is_cflag_set(ncfiles->get_ilev(),NCCOORD_FLAG_PRESSURE)) then begin
            ; must re-establish a linear transformation along Y axis
            plot,[0,1],[0,1], xstyle=4, ystyle=4, position=self.plot2d_position, $
                 charsize=self.charsize, /noerase, /nodata
            if (ptr_valid((self.extractors[self.igui]).alt_data)) then begin
               pdata=*self.ys
               zdata=*((self.extractors[self.igui]).alt_data)
               self->draw_axis,'right',range=self.yrange, yticks=7, ytickformat='pressure2altitude',/log,title='Aprox. Alt. (km)',color=!D.Table_Size-COL_TITLES
            endif else begin
               yrange = -H0*alog(self.yrange/P0) ; Y range in kms               
               self->draw_axis,'right',range=yrange,title='Altitude (km)',color=!D.Table_Size-COL_TITLES
            endelse
            self.ytitle='Pressure (mb)'
        endif else if (ncfiles->is_cflag_set(ncfiles->get_ilev(),NCCOORD_FLAG_KM)) then begin

             yrange = P0*exp(-self.yrange/H0) ; Y range in mbar
             self->draw_axis,'right',range=yrange,title='Pressure (mb)',color=!D.Table_Size-COL_TITLES, log=1
             self.ytitle='Altitude (km)'
        endif
   endif

   ; draw X-Y axis (also, reset coordinate tranformation, otherwise zooming does not work)
   IF self.ylog THEN BEGIN    ;; fancy log labels
      tmpyrange = self.yrange[sort(self.yrange)]

;      IF (tmpyrange[1]/tmpyrange[0]) LT 20. THEN BEGIN
;        print,'fine=3'
;         loglabels = loglevels(self.yrange, fine=3)
;      ENDIF ELSE BEGIN
;        print,'fine=2'
;         loglabels = loglevels(self.yrange, fine=2)
;      ENDELSE

      decades = alog10(tmpyrange[1]) -  alog10(tmpyrange[0])

      if ( decades lt 2 ) then fine = 3 $ 
      else if ( decades lt 5 ) then fine = 2 $
      else if ( decades lt 7 ) then fine = 1 $
      else fine = 0

      loglabels = loglevels(self.yrange, fine=fine)

      if ( (self.icx eq MYTIM)and(self.timeaxistype eq ABSOLUTE) ) then begin ; draw tick marks at data locations

        range=self.xrange
;        tickvals = self->get_time_tickvals()
        ((self->get_gui())->get_ncfiles())->get_timetickvals, tickvals, ticklabels, times=range, minor=xminor
        nticks = n_elements( tickvals )

        ; IDL 5.3 does not draw the first tick mark for large values - so we subtract the starttime
;        range = self.xrange - starttime
;        tickvals = tickvals - starttime

        
        contour, findgen(2,2), findgen(2), findgen(2), $
               xrange=range, xstyle=1, xtitle=self.xtitle, $
               yrange=self.yrange, ystyle=1+8*hasvertical, ytitle=self.ytitle+'!C!C', $
               zrange=self.zrange, zstyle=1, $
               xlog=self.xlog, ylog=self.ylog, $
               position=self.plot2d_position, $
               title=self.title, $
               charsize=self.charsize, $
               color=!D.Table_Size-COL_TITLES, $
               ticklen=-0.015, $
;               xtickformat=xtickformat_function, $
               xtickname=ticklabels, $
               yticks=n_elements(loglabels)-1, $
               ytickv=loglabels, $
               ytickname=replicate(' ',30), $
               xtickv=tickvals, $
               xminor=xminor, $
               xticks=nticks-1, $ ; number of tick intervels
               min_value=NULL_VALUE, $
               /nodata, /noerase
      endif else begin
        contour, findgen(2,2), findgen(2), findgen(2), $
               xrange=self.xrange, xstyle=1, xtitle=self.xtitle, $
               yrange=self.yrange, ystyle=1+8*hasvertical, ytitle=self.ytitle+'!C!C', $
               zrange=self.zrange, zstyle=1, $
               xlog=self.xlog, ylog=self.ylog, $
               position=self.plot2d_position, $
               title=self.title, $
               charsize=self.charsize, $
               color=!D.Table_Size-COL_TITLES, $
               ticklen=-0.015, $
               xtickformat=xtickformat_function, $
               yticks=n_elements(loglabels)-1, $
               ytickv=loglabels, $
               ytickname=replicate(' ',30), $
               min_value=NULL_VALUE, $
               /nodata, /noerase

      endelse


;      IF max(abs(self.yrange)) GT 1.e4 OR min(abs(self.yrange)) LT 10. THEN $
;         theFormat = '(E10.1)' ELSE theFormat = '(I5)'
;      axlabel, loglabels, /YAxis, charsize=self.charsize, $
;               color=!D.Table_Size-COL_TITLES, format=theFormat

      lvls = where(loglabels lt 1.)
      if (lvls[0] gt -1) then $
        axlabel, loglabels[lvls], /YAxis, charsize=self.charsize, $
                 color=!D.Table_Size-COL_TITLES, format='(G10.1)'

      lvls = where(loglabels ge 1.)
      if (lvls[0] gt -1) then $
        axlabel, loglabels[lvls], /YAxis, charsize=self.charsize, $
                 color=!D.Table_Size-COL_TITLES, format='(F10.0)'

   ENDIF ELSE BEGIN     ;; standard labeling
      if ( (self.icx eq MYTIM)and(self.timeaxistype eq ABSOLUTE) ) then begin ; draw tick marks at data locations

        range=self.xrange

;        tickvals = self->get_time_tickvals()
        ((self->get_gui())->get_ncfiles())->get_timetickvals, tickvals, ticklabels, times=range, minor=xminor
        nticks = n_elements( tickvals )
 
        ; IDL 5.3 does not draw the first tick mark for large values - so we subtract the starttime
;        range = self.xrange - starttime
;        tickvals = tickvals - starttime

        contour, findgen(2,2), findgen(2), findgen(2), $
               xrange=range, xstyle=1, xtitle=self.xtitle, $
               yrange=self.yrange, ystyle=1+8*hasvertical, ytitle=self.ytitle, $
               zrange=self.zrange, zstyle=1, $
               xlog=self.xlog, ylog=self.ylog, $
  ;             xtickformat=xtickformat_function, $
               xtickname=ticklabels, $
               position=self.plot2d_position, $
               color=!D.Table_Size-COL_TITLES, $
               ticklen=-0.02, $ ; default ticklen, extended outward
               title=self.title, $
               charsize=self.charsize, $
               xtickv=tickvals, $
               xminor=xminor, $
               xticks=nticks-1, $ ; number of tick intervels
               /nodata, /noerase
      endif else begin
        contour, findgen(2,2), findgen(2), findgen(2), $
               xrange=self.xrange, xstyle=1, xtitle=self.xtitle, $
               yrange=self.yrange, ystyle=1+8*hasvertical, ytitle=self.ytitle, $
               zrange=self.zrange, zstyle=1, $
               xlog=self.xlog, ylog=self.ylog, $
               xtickformat=xtickformat_function, $
               position=self.plot2d_position, $
               color=!D.Table_Size-COL_TITLES, $
               ticklen=-0.02, $ ; default ticklen, extended outward
               title=self.title, $
               charsize=self.charsize, $
               /nodata, /noerase
      endelse

   ENDELSE

;mgs--
END

PRO geov_plotter::plot2d_draw_map_grid
    @geov_pars
    @map_pars

;;mgs++   CHANGED 02 APRIL 2002 !! ***
    map_continents, mlinethick=1.5, color=!D.Table_Size-COL_CONTINENTS
    if (self.map_flags[MAP_FLAG_BORDER] eq 1) then map_grid, /box_axes, $
       color=!D.Table_Size-COL_GRID, charsize=self.charsize $
;    ELSE map_grid, /label, latdel=45, londel=45, color=!D.Table_Size-COL_GRID, $
;              glinest=2
    ELSE map_grid, /label, latdel=20, londel=30, color=!D.Table_Size-COL_GRID, $
                   glinest=0, charthick=1.5, charsize=1.5, lonlab=self.map_lonlab, latlab=self.map_latlab

END

PRO geov_plotter::plot2d, success=success
    @geov_pars
    ; local variables
    if ((geov_get_bit_struct(self.ptype)).mapbit gt 0) then ismap=1 else ismap=0 ; map flag

    ; prepare data (local copy of data arrays within zooming limits)
    self->plot2d_prepare_data, xs, ys, data, odata, $
       uwind=uwind, vwind=vwind, ismap=ismap, oxs=oxs, oys=oys, success=success

    if (success eq 0) then return

    ;; remember old plot position
    oldpos = self.plot2d_position

    ; compute default contour edges, corresponding colors
    ;CBG - Keep the missing values out of the scale of the plot.
;    vnull = NULL_VALUE ; data missing value
    vnull = ((self.extractors[self.igui]).ncfiles)->get_vnull((self.extractors[self.igui]).vid)

    if (self.auto_contour eq 1 or (not ptr_valid(self.edges))) then begin

      case self.auto_log_linear of

        0:    self->compute_edges, data, vnull
	1:    self->compute_edges, data, vnull, /autolog
	2:    self->compute_edges, data, vnull, /autolinear
	else: self->compute_edges, data, vnull

      endcase

    endif

    if (ptr_valid(self.colors)) then ptr_free, self.colors
    self.colors = self.color_manager->get_colors(n_elements(*self.edges)-1)

    ; setup plot view (map_set or contour,/nodata)
    self->plot2d_setup_view, xs, ys, data, ismap=ismap

    ; draw data on plot
    if (self.contour_opt eq CONTOUR_OPT_BOXES) then begin
        self->plot2d_draw_boxes, xs, ys, data, ismap=ismap
    endif else begin
        ; filled contour
        if (self.contour_opt eq CONTOUR_OPT_FILLED or $
            self.contour_opt eq CONTOUR_OPT_LINES_FILLED) then begin
            self->plot2d_draw_contour, xs, ys, data, *self.edges, *self.colors, ismap=ismap, filled=1
        endif
        ; lines contour
        if (self.contour_opt eq CONTOUR_OPT_LINES_MONO or $
            self.contour_opt eq CONTOUR_OPT_LINES_COLORED or $
            self.contour_opt eq CONTOUR_OPT_LINES_FILLED ) then begin
            CASE self.contour_opt OF
                 CONTOUR_OPT_LINES_MONO: colors=[!D.Table_Size-COL_CONTOURS]
                 CONTOUR_OPT_LINES_COLORED: colors=*self.colors
                 CONTOUR_OPT_LINES_FILLED: colors=[!D.Table_Size-COL_CONTOURS]
            ENDCASE
            self->plot2d_draw_contour, xs, ys, data, *self.edges, colors, ismap=ismap, filled=0
        endif
    endelse

    ; draw overplot data?
    if (ptr_valid(odata)) then begin
      if (self.oplot_samescale) then edges=*self.edges $
      else                           edges=*self.oedges
      self->plot2d_draw_contour, oxs, oys, odata, edges, [!D.Table_Size-COL_OVERPLOT], ismap=ismap, filled=0    
    endif

;mgs++
    ; overlay wind vectors?
    hasvertical = (self.icy eq MYLEV)
    IF self.uvwind_flag AND NOT hasvertical THEN BEGIN   ;;  AND XY PLOT !!!!!!!!
       self->plot2d_overlayvector, xs, ys, uwind, vwind, color=!D.Table_Size-COL_VECTORS
    ENDIF
;mgs--

    ; draw axis or map grid
    if (ismap) then begin
       self->plot2d_draw_map_grid
    endif else begin
       self->plot2d_draw_axis
    endelse

    ; color bar
    IF self.contour_opt NE CONTOUR_OPT_LINES_MONO THEN begin
      ;if ( self.scale_format eq  FORMAT_OPT_AUTO ) then begin
      if ( self.scale_format eq  0 ) then begin
        mycolorbar, *self.colors, *self.edges, self.bar_position, $
                   charsize=self.charsize, $
                   vertical=self.colorbar_vertical, $
                   textcolor=!D.Table_Size-COL_COLORBAR
      endif else begin

        ;case self.scale_format of
	;  FORMAT_OPT_F6_2 : colorbar_format = '(F6.2)'
	;  FORMAT_OPT_E10_2 : colorbar_format = '(E10.2)'
	;  else : colorbar_format = '(G10.2)'
        ;endcase
        if ( (self.scale_format gt 0) and (self.scale_format lt n_elements(CONLABS_FORMAT_OPTS)) ) then $
            colorbar_format = '('+CONLABS_FORMAT_OPTS[self.scale_format]+')' $
        else  colorbar_format = '(G10.2)'

        mycolorbar, *self.colors, *self.edges, self.bar_position, $
                   charsize=self.charsize, $
                   format=colorbar_format, $
                   vertical=self.colorbar_vertical, $
                   textcolor=!D.Table_Size-COL_COLORBAR
      endelse
    ENDIF ; colorbar

;mgs++
    ; file name in lower left corner
    if (self.filename_info) then xyouts, 0.05, 0.02, self.ncfilename, /norm, charsize=0.7, color=!D.Table_Size-COL_TITLES
    if (self.datetime_info) then xyouts, 0.95, 0.02, getenv('USER')+' '+StrDate(/german), /norm, $
       align=1., charsize=0.7, color=!D.Table_Size-COL_TITLES
;mgs--

    ;; restore old plot position
    self.plot2d_position = oldpos

    ; destroy local data
    ptr_free, data
    ptr_free, xs
    ptr_free, ys
    if (ptr_valid(odata)) then ptr_free, odata

    ; error message for uniform fields
    if (self.zrange[0] eq self.zrange[1]) then self->plot_message, string('UNIFORM FIELD=',self.zrange[0])

END
