PRO geov_plotter::plot1d_prepare_data, xs, ys, os, oxs=oxs, oys=oys, success=success
    @geov_pars
    @nccoord_pars

    ; retrieve coordinate range, subset data arrays
    if (self.icx ge 0) then begin
        xlimits = self.zoomer->get_coord_limits(self.icx)
        xcmin = xlimits[0]
        xcmax = xlimits[1]
        indexes = ptr_new(where(*self.xs ge xcmin and *self.xs le xcmax, counts))
        if ( counts lt 1 ) then begin
          success = 0
          return
        endif
        xs = ptr_new((*self.xs)[*indexes])
        ys = ptr_new((*self.data)[*indexes])

;        if (self.operator eq OP_OVERPLOT) then begin
        if (ptr_valid(self.odata)) then begin
           indexes = ptr_new(where(*self.oxs ge xcmin and *self.oxs le xcmax, counts))
           oxs = ptr_new((*self.oxs)[*indexes])
           oys = ptr_new((*self.odata)[*indexes])
        endif else begin
           oxs = ptr_new()
           oys = ptr_new()
        endelse
    endif
    if (self.icy ge 0) then begin
        ylimits = self.zoomer->get_coord_limits(self.icy)

        ycmin = ylimits[0]
        ycmax = ylimits[1]

        indexes = ptr_new(where(*self.ys ge ycmin and *self.ys le ycmax, counts))
        if ( counts lt 1 ) then begin
          success = 0
          return
        endif

        xs = ptr_new((*self.data)[*indexes])
        ys = ptr_new((*self.ys)[*indexes])

;        if (self.operator eq OP_OVERPLOT) then begin
        if (ptr_valid(self.odata)) then begin
           indexes = ptr_new(where(*self.oys ge ycmin and *self.oys le ycmax, counts))
           oxs = ptr_new((*self.odata)[*indexes])
           oys = ptr_new((*self.oys)[*indexes])
        endif else begin
           oxs = ptr_new()
           oys = ptr_new()
        endelse

    endif


    ; compute x,y minimum and maximum in range
    ; (for data, must disregard null values)
    ; set axes range
    ;CBG - Keep the missing values out of the scale of the plot.
 ;   vnull = NULL_VALUE
    vnull = ((self.extractors[self.igui]).ncfiles)->get_vnull((self.extractors[self.igui]).vid)
    if (self.icx ge 0) then begin
        xdmin = min(*xs, max=xdmax)
        self.xrange = [xdmin, xdmax]
    endif else self.xrange = self->compute_minmax(xs, vnull)
    if (self.icy ge 0) then begin
        ydmin = min(*ys, max=ydmax)
        self.yrange = [ydmin, ydmax]
    endif else self.yrange = self->compute_minmax(ys, vnull)
    ; possibly invert Y axis?
    if (self.icy eq MYLEV or self.icy eq MYLEVI) then begin
        ncfiles = (self->get_gui())->get_ncfiles()
        if (ncfiles->is_cflag_set(ncfiles->get_ilev(),NCCOORD_FLAG_DOWN)) then self.yrange = [ydmax, ydmin]
    endif
    if (self.icx ge 0) then self->set_message,string('DATA MINIMUM=',self.yrange[0],' MAXIMUM=',self.yrange[1])
    if (self.icy ge 0) then self->set_message,string('DATA MINIMUM=',self.xrange[0],' MAXIMUM=',self.xrange[1])
    ; check axis range
    if (self.xrange[0] eq self.xrange[1]) then self.xrange[0:1] = [self.xrange[0]-1.,self.xrange[0]+1]
    if (self.yrange[0] eq self.yrange[1]) then self.yrange[0:1] = [self.yrange[0]-1.,self.yrange[0]+1]

    ; overplot data
;    if (self.operator eq OP_OVERPLOT) then begin
    if (ptr_valid(self.odata)) then begin
      os = ptr_new((*self.odata)[*indexes])
      odmin = min(*os, max=odmax)
      self.orange = [odmin, odmax]

        ; want both plots to have the same range  -  if both quantities have eqaul units
      if ( self.oplot_samescale ) then begin
        if (self.icx ge 0) then begin
          self.orange[0] = min([self.orange[0],self.yrange[0]])
          self.orange[1] = max([self.orange[1],self.yrange[1]])
          self.yrange = self.orange
        endif
        if (self.icy ge 0) then begin
          self.orange[0] = min([self.orange[0],self.xrange[0]])
          self.orange[1] = max([self.orange[1],self.xrange[1]])
          self.xrange = self.orange
        endif
      endif

    endif

    ptr_free, indexes

    success = 1

END

PRO geov_plotter::plot1d_draw_data, xs, ys, color=color
    @geov_pars
    common geov_plotter_timestamp_common, ncfiles, timescale, starttime

    
    oplot,*xs, *ys,      $
          color=color,   $
          min_value=NULL_VALUE, $
          psym=-2
END

PRO geov_plotter::plot1d_setup_view, xs, ys, title=title, color=color, noerase=noerase
    @geov_pars

    if (keyword_set(noerase)) then begin
        xstyle=5  ; exact axis, not drawn
        ystyle=5  ; exact axis, not drawn
    endif else begin
        xstyle=1  ; exact axis, drawn
        ystyle=1  ; exact axis, drawn
    endelse

    ; set coordinate transformation X,Y axis
    plot,*xs, *ys, $
         xrange=self.xrange, xstyle=xstyle, $ ; exact axis
         yrange=self.yrange, ystyle=ystyle, $ ; exact axis
         ticklen=0, $
         xtickformat='empty_string', ytickformat='empty_string', $
         xlog=self.xlog, ylog=self.ylog, $
         position=self.plot1d_position, $
         charsize=self.charsize, $
         title=title, $
         min_value=NULL_VALUE, $
         color=color,     $
         noerase=noerase, $
         /nodata

END

PRO geov_plotter::plot1d, success=success
  common geov_plotter_timestamp_common, ncfiles, timescale, starttime
  common pressure2altitude_common, pdata, zdata
    @geov_pars
    @nccoord_pars


    ; load colors for plotting
;    mycolors = self.color_manager->load_colors(['blue','red'])
  ;  mycolor = mycolors[0]
  ;  mycolor2= mycolors[1]

    mycolor=!D.Table_Size-COL_LINES
    mycolor2=!D.Table_Size-COL_OLINES

    ; reference to ncfiles object, necessary to call customized time stamp method
    ncfiles = (self->get_gui())->get_ncfiles()
    p2coords = ncfiles->get_p2coords()


    ; prepare data (local copy of data arrays within zooming limits)
    self->plot1d_prepare_data, xs, ys, os, oxs=oxs,oys=oys, success=success

    if ( success eq 0 ) then return

    ; set function handling X axis labels
    xtickformat_function=self->set_x_axis_labels()

    ; setup X,Y axis
    self->plot1d_setup_view, xs, ys, title=self.title, color=!D.Table_Size-COL_TITLES

    if (self.icy eq MYLEV or self.icy eq MYLEVI) then begin
        if (ncfiles->is_cflag_set(ncfiles->get_ilev(),NCCOORD_FLAG_PRESSURE)) then begin
            self.ytitle = 'Pressure (mb)'
        endif else if (ncfiles->is_cflag_set(ncfiles->get_ilev(),NCCOORD_FLAG_KM)) then begin
             self.ytitle = 'Altitude (km)'
        endif
    endif

    ; draw axis, data
    self->plot1d_draw_data, xs, ys, color=mycolor ; uses plot ranges defined in plot1d_setup_view

    self->draw_axis, 'bottom', range=self.xrange, title=self.xtitle, color=!D.Table_Size-COL_TITLES, $
       log=self.xlog, xtickformat=xtickformat_function
    self->draw_axis, 'left', range=self.yrange, title=self.ytitle, color=!D.Table_Size-COL_TITLES, $
       log=self.ylog

    ; overplot data?
;    if (self.operator eq OP_OVERPLOT) then begin
    if (ptr_valid(self.odata)) then begin

        ; odata vs xs
        if (self.icy lt 0) then begin
            self->draw_axis, 'right', range=self.orange, title=self.otitle, log=self.ylog, color=mycolor2 ; new Y axis
            self->plot1d_draw_data, oxs, os, color=mycolor2

        ; ys vs odata
        endif else if (self.icx lt 0) then begin
            self->draw_axis, 'top', range=self.orange, title=self.otitle, log=self.xlog, color=mycolor2 ; new X axis
            self->plot1d_draw_data, os, oys, color=mycolor2
        endif

    endif

    ; draw another Y axis ?
    if (self.icy eq MYLEV or self.icy eq MYLEVI) then begin
        if (ncfiles->is_cflag_set(ncfiles->get_ilev(),NCCOORD_FLAG_PRESSURE)) then begin
            ; must re-establish a linear transformation along Y axis
            plot,[0,1],[0,1], xstyle=4, ystyle=4, position=self.plot1d_position, charsize=self.charsize, /noerase, /nodata
            if (ptr_valid((self.extractors[self.igui]).alt_data)) then begin
               pdata=*self.ys
               zdata=*((self.extractors[self.igui]).alt_data)
               self->draw_axis,'right',range=self.yrange, yticks=7, ytickformat='pressure2altitude',/log,title='Aprox. Alt. (km)',color=!D.Table_Size-COL_TITLES
            endif else begin
               yrange = (-H0)*alog(self.yrange/1000.)  ; Y range in kms
               self->draw_axis,'right',range=yrange,title='Altitude (km)',color=!D.Table_Size-COL_TITLES
            endelse
            self.ytitle = 'Pressure (mb)'
        endif else if (ncfiles->is_cflag_set(ncfiles->get_ilev(),NCCOORD_FLAG_KM)) then begin

             yrange = 1000.*exp(-self.yrange/H0) ; Y range in mbar
             self->draw_axis,'right',range=yrange,title='Pressure (mb)', $
                color=!D.Table_Size-COL_TITLES,log=1
             self.ytitle = 'Altitude (km)'
        endif
    endif

    ; reset X,Y axis (for zooming)
    self->plot1d_setup_view, xs, ys, /noerase

    ; reload previous color table
 ;;??   self.color_manager->reloadct

    ; message
   ;;?? if (self.zrange[0] eq self.zrange[1]) then self->plot_message, string('UNIFORM FIELD=',self.zrange[0])

    ; cleanup
    ptr_free, xs
    ptr_free, ys
    if (ptr_valid(os)) then ptr_free, os

END
