; driver method for plotting data already extracted from files
; KEYWORDS: noinit: set this keyword to avoid pre-plotting stage
PRO geov_plotter::plot, noinit=noinit, success=success, write_data=write_data
    @geov_pars
    if ((strlowcase(!d.name) eq 'x') or (strlowcase(!d.name) eq 'win')) then self->focus

    ; initialize plot parameters
    oldbg = !P.background
    !P.background = !D.Table_Size-1

    if (not keyword_set(noinit)) then begin

      ; set parameters for plotting
      self->setup_params
    endif

    ; plot
    pstruct = geov_get_bit_struct(self.ptype)
    if (pstruct.xbit eq VARBIT or pstruct.ybit eq VARBIT) then begin
         self->plot1d, success=success
    endif else begin
         self->plot2d, success=success
    endelse

    if keyword_set(write_data) then $
       self->dump_data_to_ncdf

    ; reset background color
    !P.background = oldbg

    if ((strlowcase(!d.name) eq 'x') or (strlowcase(!d.name) eq 'win')) then self->focus

    ; do QUIET garbage collection after each plotting
    heap_gc  ;; , /verbose

END
