; method to drive plotting process
PRO geov_plotter::main, noextractors=noextractors
    @geov_pars
    ; instantiate extractors (unless otherwise specified)
    if (not keyword_set(noextractors)) then begin
        err = self->extractors()
        if (err ne 0) then return
    endif

    ; import user selection from current gui
    self->import_all

    ; clear display message
    self->set_message,''

    ; reset zoomer display status
    self.zoomer->set_is_showing, 0

    ; loop over data extractors
    for ix=0, n_elements(self.extractors)-1 do begin
      if (obj_valid(self.extractors[ix])) then begin

          if ((ix eq self.igui) $ ; current gui
              ;or (self.operator eq OP_USR_DEF) $
              or (self->is_binary(self.operator) eq 1) ) then begin ; first 2-fields operator

              ; construct actions array for this plot
              (self.extractors[ix])->make_actions, self.ptype

              ex_type=((self.extractors[ix])->get_gui())->get_extractor_type()

              ; extract data
              ok = (self.extractors[ix])->extract_data( hourglass=self.hourglass, ex_type=ex_type )

              if (not ok) then return
           endif

      endif
    endfor

   ; combine data from the two files
    err = self->operate_data()
    if (err ne 0) then return

   ; call driver for plotting methods
    self->plot

END
