FUNCTION geov_plotter::init, manager, window_size, $
         xoffset=xoffset, yoffset=yoffset, title=title,logpval=logpval
  @geov_pars


  ; precompile access methods
  self->set
  self->get
  self->reset
  self->import

  ; save reference to parent manager
  self.manager = manager

  ; gui superclass constructor --> calls build_gui
  self.window_size = window_size

  ok = self->gui::INIT(title=title,                    $ ; keywords used to build base widget
                       registername='GEOV_PLOTTER',    $
                       /kbrd_focus_events,             $
                       /tlb_size_events,               $
                       /column,                        $
                       xoffset=xoffset,yoffset=yoffset)  ; position below geov_gui

  ; mapper superclass constructor
  ok = self->mapper::INIT()

  ; instantiates zoomer
  self.zoomer = obj_new('geov_zoomer',self)

  ; instantiate color manager
  self.color_manager = obj_new('color_manager')
  self.color_manager->loadmyct,COLOR_TABLE_RED_TEMPERATURES

  ; initialise drawing colors
  self.drawcolors[COL_BACKGROUND] = 'white'
  self.drawcolors[COL_TITLES] = 'black'
  self.drawcolors[COL_CONTOURS] = 'black'
  self.drawcolors[COL_OVERPLOT] = 'black'
  self.drawcolors[COL_COLORBAR] = 'black'
  self.drawcolors[COL_CONTINENTS] = 'black'
  self.drawcolors[COL_GRID] = 'black'
  self.drawcolors[COL_VECTORS] = 'black'
  self.drawcolors[COL_LINES] = 'black'
  self.drawcolors[COL_OLINES] = 'red'

  ; initialization
;;  self.contour_opt = CONTOUR_OPT_LINES_FILLED
  self.contour_opt = (self.manager->get_preferences())->get_contour_opt()
  self.astep = 1
  self.astart= 0

  self.filename_info = 1B
  self.datetime_info = 1B

  self.uvwind_flag = 0
  self.scale_factor = 1.

  ; set the default time aixs type
  self.timeaxistype = RELATIVE

  self.coption=-1L
  self.usr_scl_fctr=1.0

  if ( n_elements(logpval) gt 0 ) then self.levs2_flag = logpval

  self.hourglass = 1
  return, 1
END
