PRO geov_plotter::draw_axis, where, range=range, title=title, color=color, log=log, $
                  xtickformat=xtickformat, ytickformat=ytickformat, yticks=yticks
  @geov_pars
  common geov_plotter_timestamp_common, ncfiles, timescale, starttime

  ticklen = -0.02 ; default ticklen, extended outward

  

    ; X axis
    if (where eq 'bottom' or where eq 'top') then begin

      if (where eq 'bottom') then xaxis=0 else xaxis=1
      if (not keyword_set(xtickformat)) then xtickformat=''

      if ( (self.icx eq MYTIM)and(self.timeaxistype eq ABSOLUTE) ) then begin ; draw tick marks at data locations


;        tickvals = self->get_time_tickvals()

        ((self->get_gui())->get_ncfiles())->get_timetickvals, tickvals, ticklabels, times=range, minor=xminor

        nticks = n_elements( tickvals )

        ; ?? IDL 5.3 does not draw the first tick mark for large values - so we subtract the starttime
;??        range = range - starttime
;        tickvals = tickvals - starttime



        axis, xaxis=xaxis, $
              xrange=range, xstyle=1, xlog=log, $
              ticklen=ticklen, $
              xtitle=title, $
;              xtickformat=xtickformat, $
              charsize=self.charsize, $
              color=color, $
              xtickv=tickvals, $
              xminor=xminor, $
              xtickname=ticklabels, $
              xticks=nticks-1, $ ; number of tick intervals
              /save

      endif else begin  ; let IDL choose tick values

       
        axis, xaxis=xaxis, $
              xrange=range, xstyle=1, xlog=log, $
              ticklen=ticklen, $
              xtitle=title, $
              xtickformat=xtickformat, $
              charsize=self.charsize, $
              color=color, $
              /save

      endelse

    ; Y axis
    endif else if (where eq 'left' or where eq 'right') then begin
        if (where eq 'left') then yaxis=0 else yaxis=1
        if (where eq 'left') then yminor=-1 else yminor=1
        if (not keyword_set(ytickformat)) then ytickformat=''
        axis, yaxis=yaxis, $
              yrange=range, ystyle=1, ylog=log, yminor=yminor, yticks=yticks, $
              ticklen=ticklen, $
              ytitle=title, $
              ytickformat=ytickformat, $
              charsize=self.charsize, $
              color=color, $
              /save
    endif


END
