PRO geov_plotter__define
    @geov_pars

    struct = { geov_plotter,               $ ; class name
               inherits gui,               $ ; superclass
               inherits mapper,            $ ; superclass
               inherits geov_guis_user,    $ ; superclass

               ; objects
               manager:obj_new(),          $ ; reference to parent geov_manager object
               extractors:objarr(MAXFILES),$ ; array of geov_extracter objects
               zoomer:obj_new(),           $ ; reference to zoomer object
               color_manager:obj_new(),    $ ; associated color manager object

               prog_win:0L, $

               ; configuration parameters
               window_size:fltarr(2),               $ ; fraction of screen size in x and y
               plot2d_position:fltarr(4),         $ ; plot position in normalized coordinates
               plot1d_position:fltarr(4),         $ ; plot position in normalized coordinates
               bar_position:fltarr(4),          $ ; colorbar position in normalized coordinates
               charsize:0.,                     $ ; global character size
               colorbar_vertical:0,             $ ; flag for colorbar orientation
               coption:-1L,                       $ ; option flag for contour level manager (mgs)
               usr_dfnd_lvls:'',        $ ; the string containing the user defined levels
               usr_scl_fctr:1.,         $ ;

               ; widgets ids
               draw_wid:0L,       $ ; widget id of draw_widget
               status_bar_wid:0L, $ ; widget id for bottom status bar

               ; plot-dependent variables
               xtitle:'',                       $ ; X,Y axis titles
               ytitle:'',                       $ ; X,Y axis titles
               title:'',                        $ ; plot title
               otitle:'',                       $ ; title for overplot variable (X or Y axis)
               sumtitle:'',                     $ ; title for summation operator plot
;mgs++
               ncfilename:'',                   $ ; label for filename
;mgs--
               xlog:0B,                         $ ; flag for logarithmic X axis
               ylog:0B,                         $ ; flag for logarithmic Y axis
               xrange:dblarr(2),                $ ; exact xs range within coordinate limits
               yrange:dblarr(2),                $ ; exact ys range within coordinate limits
               zrange:dblarr(2),                $ ; exact data range within coordinate limits
               orange:dblarr(2),                $ ; exact overplot data range within coordinate limits
               colors:ptr_new(),                $ ; array of color indexes to be used for contours
               drawcolors:strarr(MAXCOLS+1),    $ ; drawing colors (names)
               contour_opt:0B,                  $ ; contour option (lines, filled. lines+filled, boxes)

               scale_format:0L,                 $ ; format option for the scale labels
               filename_info:1B,                $ ; option to include filename info on plot
               datetime_info:1B,                $ ; option to include date/time info on plot

               timeaxistype:RELATIVE,           $ ; time axis type - absolute or relative time/date labeling

               map_latlab:0 ,                      $ ; longitude at which the latitude labels are set
               map_lonlab:0 ,                      $ ; latitude at which the longitude labels are set

               ; plot-specific variables
               ptype:0L,                   $ ; plot type
               icx:0,                      $ ; index of coordinate on X axis (MYLAT, MYLON, MYLEV, MYTIM)
               icy:0,                      $ ; index of coordinate on Y axis (MYLAT, MYLON, MYLEV, MYTIM)
               scaling:0B,                 $ ; flag to enable/desable scaling
               oplot_samescale:0B,         $ ; flag to enable/desable using same scale for overplots
               scale_factor:0.,            $ ; variable scale factor (1E-6, 1E-9, 1E-12)
               auto_contour:0B,            $ ; flag to compute automatic contour levels
               auto_log_linear:0L,         $ ; auto-log/inear option flag
               levs2_flag:0B,              $ ; flag to use levs2 instead of levs in plot title
;mgs++
               uvwind_flag:0,              $ ; flag for wind vector overlay
               operator:0,                 $ ; data operator
               extractor_type:0,                $ ; data extractor type
               edges:ptr_new(),            $ ; pointer to contour edges
               oedges:ptr_new(),           $ ; pointer to contour edges for overplot

               ; animation parameters
               astep:1,                    $ ; show one every astep frames
               astart:0,                   $ ; start animation from frame astart

               ; data arrays
               xs:ptr_new(),               $ ; copy of xs from current extractor
               ys:ptr_new(),               $ ; copy of ys from current extractor
               oxs:ptr_new(),               $ ; copy of xs from current extractor
               oys:ptr_new(),               $ ; copy of ys from current extractor
               data:ptr_new(),             $ ; combined data from two extractors
               odata:ptr_new(),            $ ; overplot data
;mgs++ (22 April 2002)
               uwind:ptr_new(),            $ ; wind vector U component
               vwind:ptr_new() ,           $ ; wind vector V component

               displayeddata:ptr_new(),    $ ; data currently displayed
               usr_expression:'',          $ ; the operator expression entered by user
               smooth_width:'', $
               hourglass:0L $
    }

END
