; datap: pointer to data
; vnull: missing value for data, or NaN
FUNCTION geov_plotter::compute_minmax, datap, vnull

  ; select indexes for use with data
  if (finite(vnull)) then indexes = where(*datap ne vnull, counts)      $ ; finite missing value
  else                    indexes = where(finite(*datap) eq 1, counts)  ; non-finite missing value

  if (counts gt 0) then begin
      dmin = min((*datap)[indexes], max=dmax )
  endif else begin
      ; data is always equal to the missing value
      dmin = vnull
      dmax = vnull
  endelse

  return, [dmin,dmax]

END
