; method to compute default edges for contour plot
; edges will be [-inf, first, ..., last, +inf]
; will work with a finite or inifinite missing value vnull
; keyword overplot: passed to self->set_edges to set self.oedges instead
PRO geov_plotter::compute_edges, data, vnull, overplot=overplot, autolog=autolog, autolinear=autolinear


  ; select indexes to use with the data
  if (finite(vnull)) then indexes = where(*data ne vnull, counts) $ ; finite missing value
  else indexes = where(finite(*data) eq 1, counts)                  ; non-finite missing value

  if (counts gt 0) then begin
      newdata = ptr_new((*data)[indexes])
      edges = make_levels(newdata, autolog=autolog, autolinear=autolinear) ; convert double --> float
      if (not ptr_valid(edges)) then begin ; failure in set_levels -> make_levels
          newmin = min(*newdata, max=newmax)
          edges = ptr_new(newmin + findgen(11)*(newmax-newmin)/10.)
      endif
      ptr_free, newdata
  endif else begin
      if (finite(vnull)) then edges = ptr_new([vnull]) $ ; only one edge = vnull
      else edges = ptr_new([0.])                         ; only one edge = 0.
  endelse

  ; add +/- Inf at the two ends
  self->set_edges, edges, overplot=overplot

  ptr_free, edges

END
