PRO geov_plotter::animate, file=file

   ;; if file keyword is set, animate produces a series of
   ;; png(?) images, which can then be used to create a movie with
   ;; an external program such as ImageMagick's convert or MainActor.
   ;; The files will be saved in the working directory as imNNNN.png
   ;; (mgs, 13 June 2002)
   ;; also added possibility to interrupt buildup of animation by
   ;; pressing the ESC key. Unfortunately, this only works if the
   ;; IDL command line window has the keyboard focus


  self.hourglass=0 ; turn off hourglass

  ; check times are compatible
  gui = (self->get_extractor())->get_gui()
  ncfiles = gui->get_ncfiles()
  ntimes = n_elements(*(ncfiles->get_times()))
  if (self->is_binary(self.operator) eq 1) then begin
      ogui = (self->get_extractor(/other))->get_gui()
      oncfiles = ogui->get_ncfiles()
      ontimes = n_elements(*(oncfiles->get_times()))
      if (ntimes ne ontimes) then begin
          message,'ERROR IN ANIMATION: TIMES ARE INCOMPATIBLE'
          return
      endif
  endif

 ;; default file name
 fnam = 'im'   ;; + NNNN.png

 ; retrieve animation parameters from gui
 self->import_anim_pars
 if (self.astep ge 1 and self.astep lt ntimes $
     and self.astart ge 0 and self.astart lt ntimes) then begin

    ; retrieve screen size
    geometry = widget_info(self.draw_wid,/geometry)
    xsize = geometry.scr_xsize
    ysize = geometry.scr_ysize

    ; create invisible window to display animation
    ;window, xsize=xsize, ysize=ysize, /pixmap, /free
    ;wid = !D.window
    ; or retrieve window id of widget_draw
    widget_control, self.draw_wid, get_value=wid

   ; number of frames
    nframes = fix((ntimes-self.astart)/self.astep)

    ; initialize Xinteranimate widget
    IF keyword_set(file) EQ 0 THEN $
       xinteranimate,set=[xsize,ysize,nframes],/track, title='ANIMATION'

    ; instantiate extractors first
    err = self->extractors()

    ; get the current time setting
    currentT = gui->get_time()

    ; create a progress window
    tlb = self.guis[0]->get_base()
    result = widget_info( tlb, /geometry )
    prog_win = obj_new( 'Progress_Window', group_leader=self.base_wid, $
                        title='Build Animation Progress', $
                        message='Building Animation...', $
                        XOffset=result.xoffset+50, $
                        YOffset=result.yoffset+50, $
                        drawsize=400,buttonTitle='Cancel Build' )

    ; loop over frames
    auto_contour = self->get_auto_contour() ; store previous value
    for ifr=0, nframes-1 do begin
        it = self.astart + ifr*self.astep ; time index

        wset, wid

        ; select time index
        gui->set_time, it
        if (self->is_binary(self.operator) eq 1) then ogui->set_time, it

        ; driver method for plotting with data extraction
        self->main, /noextractors ; keep using the same extractors

        ; mimic 'fix contour' event, so that all other plots will have same scale
        if (ifr eq 0) then begin
            self->set_auto_contour, 0
            gui->set_auto_contour, 0
            gui->import_edges ; store plotter edges in gui
        endif

        ;; load plot into xinteranimate or save to file
        IF keyword_set(file) THEN BEGIN
           thisfile = fnam+string(ifr+1,format='(i4.4)')
           dummy = tvread(filename=thisfile,/png,order=float(!version.release) GT 5.4, $
                          /nodialog)
        ENDIF ELSE BEGIN
           xinteranimate, frame=ifr, window=wid
        ENDELSE

        ; update the progress bar
        percentDone = float(ifr+1)/float(nframes)
        prog_win->update,percentDone

        ; check to see if someone has pressed the cancel button
        if ( prog_win->canceled() ) then goto, skip

    endfor

    prog_win->finish

    ; start xinteranimate and set the initial animation rate to 0%
    ; Note: The animation rate can be range from 0 to 100.
    ;       The default rate is 100.

    IF keyword_set(file) EQ 0 THEN xinteranimate, 20

    skip:

    ; destroy the progress window - we are finished with it
    if ( obj_valid( prog_win ) ) then obj_destroy, prog_win

    ; set time selection back to the original current time
    gui->set_time, currentT



    ; reset drawing window
    widget_control, self.draw_wid, get_value=wid
    wset, wid

    ; reset
    gui->set_auto_contour, auto_contour
    self->set_auto_contour, auto_contour

  endif else message,'ERROR IN ANIMATION: WRONG STEP OR START'

  self.hourglass=1 ; turn on hourglass
END
