; maximum number of simultaneously opened netCDF files
MAXFILES = 4

; maximum number of simulteneously opened windows
MAXSCREENS = 4

; maximum number of data directories
MAXDIRS = 10

; uniform null value for all data
;
; CGB - This need to be a true null so that missing values get skipped during
; come calculations
NULL_VALUE = !Values.F_NaN

; maximum number of coordinates
MAXCOORDS = 5
; coordinates ordering
MYLAT = 0
MYLON = 1
MYLEV = 2
MYTIM = 3
MYLEVI= 4

; coordinate bits
LATBIT = 1B
LONBIT = 2B
LEVBIT = 4B
TIMBIT = 8B

; variable bit
VARBIT = 9B

; action codes
XAXIS = -1
YAXIS = -2
ZAXIS = -3
AVERAGE=-4
CONSTPRESS=-5
WEIGHTEDAVE=-6

; number of possible plot types
MAX_NUMBER_OF_PLOTS = 50

; maps
NO_MAP = 0
MAP    = 1012    & MAP_TITLE    = 'Current Map'
MAP_AT = 2012    & MAP_AT_TITLE = 'Atlantic View'
MAP_PA = 3012    & MAP_PA_TITLE = 'Pacific View'
MAP_NP = 4012    & MAP_NP_TITLE = 'North Polar View'
MAP_SP = 5012    & MAP_SP_TITLE = 'South Polar View'
MAP_GP = 6012    & MAP_GP_TITLE = 'Generic Polar View'
MAP_USER=9012    & MAP_USER_TITLE = 'User Defined Map'

; plot type
LATvsLON = 12 & LATvsLON_TITLE = 'Latitude vs Longitude'
LATvsLONpress = 40012 & LATvsLONpress_TITLE = 'Latitude vs Longitude at Constant Pressure...'
LEVvsLAT = 41 & LEVvsLAT_TITLE = 'Meridional slice'
LEVvsLON = 42 & LEVvsLON_TITLE = 'Zonal slice'
 
LATvsTIM = 18 & LATvsTIM_TITLE = 'Time evolution, meridional structure'
LONvsTIM = 28 & LONvsTIM_TITLE = 'Time evolution, zonal structure'
LEVvsTIM = 48 & LEVvsTIM_TITLE = 'Time evolution, vertical structure'

LONaveLEVvsLAT = 241    & LONaveLEVvsLAT_TITLE = 'Zonal average'

VARvsLON = 92   & VARvsLON_TITLE = 'Longitide profile'
VARvsLAT = 91   & VARvsLAT_TITLE = 'Latitude profile'
LEVvsVAR = 49   & LEVvsVAR_TITLE = 'Vertical profile'
VARvsTIM = 98   & VARvsTIM_TITLE = 'Time series'
;TotalMASSvsTIM = 58   & TotalMASSvsTIM_TITLE = 'Total tracer mass time series'

LONaveVARvsLAT = 291 & LONaveVARvsLAT_TITLE = 'Latitude profile, zonal average'
LONaveLEVvsVAR = 249 & LONaveLEVvsVAR_TITLE = 'Vertical profile, zonal average'
LONaveVARvsTIM = 298 & LONaveVARvsTIM_TITLE = 'Time series, zonal average'

LONaveLATvsTIM = 218 & LONaveLATvsTIM_TITLE = 'Time evolution, zonal average, meridional structure'
LONaveLEVvsTIM = 248 & LONaveLEVvsTIM_TITLE = 'Time evolution, zonal average, vertical structure'

LATLONaveLEVvsVAR = 349 & LATLONaveLEVvsVAR_TITLE = 'Vertical profile, global average'
LATLONaveVARvsTIM = 398 & LATLONaveVARvsTIM_TITLE = 'Time series, global average'
LATLONaveLEVvsTIM = 348 & LATLONaveLEVvsTIM_TITLE = 'Time evolution, global average, vertical structure'

LATaveLEVvsVAR = 149 & LATaveLEVvsVAR_TITLE = 'Vertical profile, global average'
LATaveVARvsTIM = 198 & LATaveVARvsTIM_TITLE = 'Time series, global average'
LATaveLEVvsTIM = 148 & LATaveLEVvsTIM_TITLE = 'Time evolution, global average, vertical structure'

; extractors
EX_SIMPLE             = 0
EX_NUM_DENS           = 1
EX_TOTAL_COL          = 2
EX_COL_ABOVE          = 3
EX_TROP_COL           = 4
EX_ABOVETROP_COL      = 5
EX_SUMMATION          = 6
EX_TOT_MASS           = -1

; operators
;OP_OVERPLOT           = -1
OP_NONE               = 0
OP_SMOOTH             = 1
OP_INVERSE            = 2
OP_USR_DEF            = 3
;OP_OVERPLOT           = 4
OP_SUM                = 4
OP_DIFFERENCE         = 5
OP_DIFFERENCE_PERCENT = 6
OP_RATIO              = 7
;operator_names = ['None','1/A','Density','Total Col.','Col. Above','Usr Def...','Tot tracer mass','Overplot','A+B','A-B','(A-B)/B','A/B','Sum...']
;operator_names = ['None','1/A','Density','Total Col.','Col. Above','Usr Def...','Overplot','A+B','A-B','(A-B)/B','A/B','Sum...']

extractor_names = ['Simple','Density','Total Col','Col Above','Trop Col','Col Above Trop','Sum...']
;operator_names  = ['None','Smooth','1/A','Usr Def...','Overplot','A+B','A-B','(A-B)/B','A/B']
operator_names  = ['None','Smooth','1/A','Usr Def...','A+B','A-B','(A-B)/B','A/B']

; maximum number of allowed edges
MAXEDGES = 21

; additional color tables
COLOR_TABLE_RED_TEMPERATURES = -1

; contour options
CONTOUR_OPT_LINES_MONO = 0
CONTOUR_OPT_LINES_COLORED = 1
CONTOUR_OPT_FILLED = 2
CONTOUR_OPT_LINES_FILLED = 3
CONTOUR_OPT_BOXES = 4

; contour format options
;FORMAT_OPT_AUTO = 0
;FORMAT_OPT_F6_2 = 1
;FORMAT_OPT_E10_2 = 2
CONLABS_FORMAT_OPTS = ['Auto','I12', 'F12.1', 'F12.2', 'F12.3', 'F12.4','F12.5','F12.6','E12.1', 'E12.2', 'E12.3', 'E12.4']


; number of drawing colors and color name indices
; (NOTE: don't use index 0)
MAXCOLS = 10
COL_BACKGROUND = 1
COL_TITLES     = 2
COL_CONTOURS   = 3
COL_OVERPLOT   = 4
COL_COLORBAR   = 5
COL_CONTINENTS = 6
COL_GRID       = 7
COL_VECTORS    = 8
COL_LINES      = 9
COL_OLINES     = 10

; parameters for log-pressure conversion
; z = -H0*ln(p/p0)
H0 = 7.0 ; in km
P0 = 1013.25 ; in mbar

; time scales
TIME_SCALE_NONE = 'None'
TIME_SCALE_SECS = 'Seconds'
TIME_SCALE_HOUR = 'Hours'
TIME_SCALE_DAYS = 'Days'
TIME_SCALE_MONS = 'Months'

; time-axis-labels types
RELATIVE = 0
ABSOLUTE = 1

; total number of time-axis types
TIMEAXIS_TYPES = 2

; earth radius in meters
REARTH = 6.37e6
