FUNCTION geov_ncfile::get_latdid
  if (self.ilat ge 0) then return, (*self.cdims)[self.ilat] $
  else return, -1
END
FUNCTION geov_ncfile::get_londid
  if (self.ilon ge 0) then return, (*self.cdims)[self.ilon] $
  else return, -1
END
FUNCTION geov_ncfile::get_levdid
  if (self.ilev ge 0) then return, (*self.cdims)[self.ilev] $
  else return, -1
END
FUNCTION geov_ncfile::get_timdid
  if (self.itim ge 0) then return, (*self.cdims)[self.itim] $
  else return, -1
END
FUNCTION geov_ncfile::get_ilat
  return, self.ilat
END
FUNCTION geov_ncfile::get_ilon
  return, self.ilon
END
FUNCTION geov_ncfile::get_itim
  return, self.itim
END
FUNCTION geov_ncfile::get_ilev
  return, self.ilev
END
FUNCTION geov_ncfile::get_ilevi
  return, self.ilevi
END

FUNCTION geov_ncfile::get_iuvar
  return, self.iuvar
END
FUNCTION geov_ncfile::get_ivvar
  return, self.ivvar
END

FUNCTION geov_ncfile::get_p2coords
  return, self.p2coords
END
FUNCTION nccoordfile::get_pvbits
  return, self.pvbits
END
FUNCTION nccoordfile::get_timestamps
  if obj_valid(self.times) then stmps = self.times->get_timelabels() else stmps = ''
  return, stmps
END
FUNCTION geov_ncfile::get_cbit, ic
  @geov_pars
  CASE ic OF
    self.ilat: return, LATBIT
    self.ilon: return, LONBIT
    self.ilev: return, LEVBIT
    self.itim: return, TIMBIT
    ELSE:      return, 0
  ENDCASE
END
FUNCTION geov_ncfile::get_lats
  if (self.ilat ge 0) then return, (*self.coords)[self.ilat] $
  else return, ptr_new() ; null pointer
END
FUNCTION geov_ncfile::get_lons
  if (self.ilon ge 0) then return, (*self.coords)[self.ilon] $
  else return, ptr_new() ; null pointer
END
FUNCTION geov_ncfile::get_levs
  if (self.ilev ge 0) then return, (*self.coords)[self.ilev] $
  else return, ptr_new() ; null pointer
END
FUNCTION geov_ncfile::get_interface_levs
  if (self.ilevi ge 0) then return, (*self.coords)[self.ilevi] $
  else return, ptr_new() ; null pointer
END
FUNCTION geov_ncfile::get_levs2
   return, self.levs2
END
FUNCTION geov_ncfile::get_interface_levs2
   return, self.interface_levs2
END
FUNCTION geov_ncfile::get_times
;;  if (self.itim ge 0) then return, (*self.coords)[self.itim] $
   if (self.itim ge 0) then BEGIN
;; *** ACCEPT DIFFERENT TIME NAMES ***
      ;; extract coordinate values and units attribute
;      timenames = [ 'Time','time', 'times', 'mtime', 'month' ]
;      vid = -1L
;      i = 0L

;      WHILE vid LT 0 AND i LT n_elements(timenames) DO BEGIN 
;         mytimenm = timenames[i]
;         vid = NCDF_VARID(self.fid, timenames[i])
;         i = i+1
;      ENDWHILE 

;      IF vid LT 0 THEN BEGIN
;        ; Message, 'Invalid variable ID for time!',/CONTINUE

         
;         dimid = -1
;         j = 0
;         while dimid lt 0 and j lt n_elements(timenames) do begin
;           dimid = NCDF_DIMID( self.fid, timenames[j] )
;           j = j + 1
;         endwhile

;         if dimid lt 0 then return, ptr_new()

;         NCDF_DIMINQ, self.fid, dimid, mytimenm, mytimeize

;         (*self.coords)[self.itim] = ptr_new( findgen( mytimeize ) )
;         return, (*self.coords)[self.itim]

;;         return, (*self.coords)[self.itim]

;      ENDIF 

;      res = ncdf_varinq( self.fid, vid )

;      if res.datatype eq 'CHAR' then begin
;         dimid = NCDF_DIMID( self.fid, mytimenm )
;         NCDF_DIMINQ, self.fid, dimid, mytimenm, mytimeize

;         ; return,ptr_new( findgen( mytimeize ))
;         (*self.coords)[self.itim] = ptr_new( findgen( mytimeize ) )
;         return, (*self.coords)[self.itim]
;      endif

;      NCDF_VARGET, self.fid, vid, times

;      (*self.coords)[self.itim] = ptr_new(times)
;      return, (*self.coords)[self.itim]
     return, self.times->get_timesptr()
   ENDIF else BEGIN
      return, ptr_new()         ; null pointer
   ENDELSE 
END

PRO geov_ncfile::get_timetickvals, ticktvals, ticklabels, times=times, minor=minor
  self.times->get_timetickvals, ticktvals, ticklabels, times=times, minor=minor
END

FUNCTION geov_ncfile::get_type
  return, self.type
END

PRO geov_ncfile::get
END
