pro geov_manager::set_plotter_window_title, plotter
  title = self->get_operand_title( plotter )
  plotter->gui::set_title,title
end

; method to instantiate a new plotter object
FUNCTION geov_manager::create_plotter, gui, window_size


    ; place plotter underneath parent gui (and stack each successive plotter)
    ; note: nwidgets includes at least geov_manager and this gui
    screen_size = get_screen_size()

;; window_size changed to reflect fraction fo screen size directly
    xsize = window_size[0] * screen_size[0]
    ysize = window_size[1] * screen_size[1]

;;    CASE window_size OF
;;      'small': BEGIN
;;                 xsize = 0.45*screen_size[0]
;;                 ysize = 0.3*screen_size[1]
;;               END
;;      'medium': BEGIN
;;                 xsize = 0.5*screen_size[0]
;;                 ysize = 0.45*screen_size[1]
;;               END
;;      'large': BEGIN
;;                 xsize = 0.95*screen_size[0]
;;                 ysize = 0.6*screen_size[1]
;;               END
;;       else:
;;    ENDCASE

    nplotters =gui->get_number_of_plotters()

;    nwidgets = n_elements(widget_info(/managed))
    gui_geometry = widget_info(gui->get_base(), /geometry)
    yoffset = gui_geometry.yoffset+gui_geometry.scr_ysize + 2*gui_geometry.margin $
            + 40 $; approximate menu bar height
            + (nplotters)*20 ; stack
;    yoffset = yoffset < ((get_screen_size())[1]-500) ; limit Y offset by screen size
    yoffset = yoffset < (screen_size[1]-ysize-120) ; limit Y offset by screen size
    xoffset = gui_geometry.xoffset $ ; same X offset as gui
            + (nplotters)*20 ; stack
;            + (nwidgets-2)*20 ; stack
;    xoffset = xoffset < ((get_screen_size())[0]-600) ; limit X offset by screen size
    xoffset = xoffset < (screen_size[0]-xsize-20) ; limit X offset by screen size


    ; look for an empty slot in the plotters array
    for ip=0, n_elements(self.plotters)-1 do begin
      ; check object is not already instantiated
      if (not obj_valid(self.plotters[ip])) then begin

          logpval = gui->get_levels_button_value()

          ; instantiate new plotter
          plotter = obj_new('geov_plotter', self, window_size, yoffset=yoffset, xoffset=xoffset, logpval=logpval )

          ; register plotter with itself and set as current
          ip1 = self->register_plotter(plotter)
          self->set_plotter, plotter

         ; register plotter with parent gui and set as current
          ip2 = gui->register_plotter(plotter)
          gui->set_plotter, plotter

         ; register gui with plotter and set as current (will never change)
          ig1 = plotter->register_gui(gui)
          plotter->set_gui, gui

          ; register plotter with all other valid guis
          for ig=0, n_elements(self.guis)-1 do begin
            if (obj_valid(self.guis[ig])) then begin
             if (self.guis[ig] ne gui) then begin
              ; register gui with plotter
              ig2 = plotter->register_gui(self.guis[ig])
             endif
            endif
          endfor

         self->set_plotter_window_title, plotter

         plotter->focus

         return, plotter
      endif
    endfor

    result = dialog_message('TOO MANY WINDOWS OPENED ALREADY!')

    return, obj_new() ; error

END
