; IDL object representing GUI for geov program
FUNCTION geov_gui::INIT, manager, ncfilenames, xoffset=xoffset, yoffset=yoffset
    @geov_pars
    @nccoord_pars
    ; precompile access methods
    self->get
    self->set
    self->import

    ; reference to parent geov_manager
    self.manager = manager

    ; open netCDF file object
;    self.ncfile = obj_new('geov_ncfile',ncfilename)
    self.ncfiles = obj_new('geov_multifiles',ncfilenames)

    if ( not obj_valid( self.ncfiles ) ) then begin
      message,'ncfiles not valid'
      return, 0
    endif

    ; superclass constructor --> calls build_gui
;    ok = self->gui::INIT(title=self.ncfile->get_fname(), $ ; keywords used to build base widget
    ok = self->gui::INIT(title=ncfilenames[0], $ ; keywords used to build base widget
                         group_leader=self.manager->get_base(), $
                         /kbrd_focus_events,             $
                         /mbar, /column, $
                         xoffset=xoffset,yoffset=yoffset) ; position in screen


     ; get the geometry after the gui is realized
     res = widget_info( self.base_wid, /geometry )

     if (float(!version.release) lt 6.0) then self.totsz = res.scr_ysize $
     else self.totsz = res.ysize

     ypad = res.ypad
     res = widget_info( self.bottom_base, /geometry )
     self.xtrsz = res.scr_ysize + ypad
    

    ;?? initially want the extra controls to be hidden
    ;self->toggel_xtr_cntrls

    ; to prevent flickering or flashing while gui is being built and
    ; repositioned on screen
    widget_control, self.base_wid, map=1, update=1

    ; allocate memory for edges pointers
    pvars = self.ncfiles->get_pvars()
    self.edges = ptr_new(ptrarr(n_elements(*pvars)))

    ; initialize fields
    if (self.ncfiles->get_ilon() ge 0) then begin
        if (self.ncfiles->is_cflag_set(self.ncfiles->get_ilon(),NCCOORD_FLAG_NEGLON)) then self.map = MAP_AT else self.map = MAP_PA
    endif
    self.map = (self.manager->get_preferences())->get_map_type()
    self->set_plot, (self.manager->get_preferences())->get_plot_type() ; may override self.map

    ; add path of current file to path list of archive manager
    filepath = extract_path(self.ncfiles->get_fname())
    data_dirs = self.manager->get_data_dirs()

    ; need to remove trailing '/' or '\'

    wp = where(remove_trailing_del(*data_dirs) EQ remove_trailing_del(filepath), cnt)
    IF cnt EQ 0 THEN BEGIN
       ;; add current directory to list (replace last entry)
       (*data_dirs)[n_elements(*data_dirs)-1] = filepath

       ;; update archive manager widget (build new one)
       valid = widget_info(self.manager->get_base(), /valid_id)
       if (valid eq 1) then begin
          wid = self.manager->get_last_dir_wid()
          widget_control, wid, set_value=filepath
       ENDIF
    ENDIF

    cd, current=curdir
    self.savepath = curdir

    return, 1

END
