; methods to update GEOV_GUI with fields from current PLOTTER object

PRO geov_gui::import_all
    self->import_ipvar
    self->import_coords
    self->import_auto_contour
    self->import_scaling
    self->import_plot
    self->import_operator
    self->import_extractor_type
END

PRO geov_gui::import_plot
    ptype = (self->get_plotter())->get_ptype()
    self->set_plot, ptype
END

PRO geov_gui::import_operator
    op = (self->get_plotter())->get_operator()
    self->set_operator, op
END

PRO geov_gui::import_extractor_type
    ex = (self->get_plotter())->get_extractor_type()
    self->set_extractor_type, ex
END

PRO geov_gui::import_scaling
    value = (self->get_plotter())->get_scaling()
    self->set_scaling, value
END

PRO geov_gui::import_auto_contour
    boolean = (self->get_plotter())->get_auto_contour()
    self->set_auto_contour, boolean
END

PRO geov_gui::import_ipvar

    ; loop over extractors for current plotter
    extractors = (self->get_plotter())->get_extractors()
    n = n_elements(extractors)
    ipvars = lonarr(n) & ipvars[*]=-1
    counts = 0
    for ix=0, n-1 do begin
      if (obj_valid(extractors[ix])) then begin
        ; request this gui to be associated with extractor
        if ( (extractors[ix])->get_gui() eq self) then begin
            ipvars[counts] = (extractors[ix])->get_ipvar()
            counts = counts+1
        endif
      endif
    endfor

    ; update widget
    if (ipvars[1] ge 0 and ipvars[1] ne ipvars[0]) then self->set_ipvar, ipvars[0:1] else self->set_ipvar, ipvars[0]

END

PRO geov_gui::import_edges
    edges = (self->get_plotter())->get_edges()
    self->set_edges, edges=edges
END

PRO geov_gui::import_coords

    ; loop over extractors for current plotter
    extractors = (self->get_plotter())->get_extractors()
    n = n_elements(extractors)
    lats = lonarr(n) & lats[*]=-1
    lons = lonarr(n) & lons[*]=-1
    levs = lonarr(n) & levs[*]=-1
    tims = lonarr(n) & tims[*]=-1
    counts = 0
    for ix=0, n-1 do begin
      if (obj_valid(extractors[ix])) then begin
        ; request this gui to be associated with extractor
        if ( (extractors[ix])->get_gui() eq self) then begin
            icoords = (extractors[ix])->get_icoords()
            ; loop over coordinates for this set of ncfiles
            for ic=0, n_elements(*icoords)-1 do begin
                   if (ic eq self.ncfiles->get_ilat()) then lats[counts] = (*icoords)[ic] $
              else if (ic eq self.ncfiles->get_ilon()) then lons[counts] = (*icoords)[ic] $
              else if (ic eq self.ncfiles->get_ilev()) then levs[counts] = (*icoords)[ic] $
              else if (ic eq self.ncfiles->get_itim()) then tims[counts] = (*icoords)[ic]
            endfor
            counts = counts+1
        endif
      endif
    endfor

    ; update widgets
    if (lats[1] ge 0 and lats[1] ne lats[0]) then self->set_lat, lats[0:1] else self->set_lat, lats[0]
    if (lons[1] ge 0 and lons[1] ne lons[0]) then self->set_lon, lons[0:1] else self->set_lon, lons[0]
    if (levs[1] ge 0 and levs[1] ne levs[0]) then self->set_lev, levs[0:1] else self->set_lev, levs[0]
    if (tims[1] ge 0 and tims[1] ne tims[0]) then self->set_time,tims[0:1] else self->set_time,tims[0]

END

PRO geov_gui::import
END
