; method to handle plot-button events
PRO geov_gui::plot_buttons_event_listener, ptype
    @geov_pars
    @map_pars
    @nccoord_pars


    ; method to update title and send information to plotter
    self->set_plot, ptype

    ; make widgets active/inactive
    self->activator, /plot_buttons,  /lists

    ; invoke interactive gui_mapper
    if (ptype eq MAP_USER) then begin
        if (self.ncfiles->is_cflag_set(self.ncfiles->get_ilon(),NCCOORD_FLAG_NEGLON)) then $
             map_system = MAP_SYSTEM_NEGATIVE $
        else map_system = MAP_SYSTEM_POSITIVE
        gui_mapper = obj_new('gui_mapper', self->get_plotter(), map_system=map_system)

    ; do new plot
    endif else begin
       ; setup new map? (not if CURRENT MAP)
       if (ptype eq MAP_AT or ptype eq MAP_PA or ptype eq MAP_NP or ptype eq MAP_SP or ptype eq MAP_GP) then $
           (self->get_plotter())->import_map

       (self->get_plotter())->main

    endelse

END


; procedure to display information on the Geov tool
PRO displayAboutInfo, parent
  strout = [ 'Version ' + !geov_version,'', geov_info() ]
  void = dialog_message(strout,/information,dialog_parent = parent)
END

;Pro geov_gui::reset_summation_op
;  @geov_pars
;  ; if OP_SUMMATION set the operator to none
;  if (obj_valid(self.plotters[self.iplotter])) then begin
;    op = (self.plotters[self.iplotter])->get_operator()
;    if( op eq OP_SUMMATION ) then begin
;      self->set_operator, OP_NONE
;      (self.plotters[self.iplotter])->set_operator, OP_NONE
;    endif
;  endif
;End

PRO geov_gui::event_listener, event
  @geov_pars

  if (event.id eq self.operator_wid) then begin
    if (event.index eq OP_SMOOTH) then begin
       (self.plotters[self.iplotter])->set_smooth_width,''
    endif
  endif

  ; determine which event type
  event_name = strlowcase(tag_names(event, /structure_name))

  self.show_sum_gui = 0

  ; FOCUS event --> set current with manager
  ; note: this focus event follows any button event generated by user action
  ; -> may cause problems in layering of pop-up windows
  if (event_name eq 'widget_kbrd_focus') then begin

      if (event.enter eq 1) then begin
          ; set this gui as current with manager
          self.manager->set_gui, self
          ; retrieve current plotter (but do not create new one if non-existing!)
          plotter = self->geov_plotters_user::get_plotter()
          if (obj_valid(plotter)) then begin
              ; set plotter as current with manager
              self.manager->set_plotter, plotter
          endif
      endif

  ; selection event
  endif else begin

    widget_control, /hourglass

    CASE event.id OF

        self.overplot_wid: begin
                             self->toggle_overplot
                             plotter = self->get_plotter()
                             plotter->main
                           end

        self.mycolors_wid: BEGIN
                             plotter = self->get_plotter()
                             if(ptr_valid(self.mydrawcolors)) then plotter->set_drawcolors, *self.mydrawcolors
                             cm = plotter->get_color_manager()
                             cm->loadmyct,COLOR_TABLE_RED_TEMPERATURES
                             plotter->plot
                           END

        self.idlcolors_wid: BEGIN
                              plotter = self->get_plotter()
                              if(ptr_valid(self.mydrawcolors)) then plotter->set_drawcolors, *self.mydrawcolors
                              cm = plotter->get_color_manager()
                              cm->loadidlct, /choose
                              plotter->plot
                            END

        self.bwrcolors_wid: begin
                             ncolors = !d.table_size-10 ; last portion of the table is used for the drawing colors (axis, etc)
                             redVec = intarr(!d.table_size)
                             grnVec = intarr(!d.table_size)
                             bluVec = intarr(!d.table_size)
                             redVec[0] = 0 ; make first color black
                             grnVec[0] = 0
                             bluVec[0] = 0
                             ncolors2 = ncolors/2

                             for i =1, ncolors2 do begin
                               frac = 1. - float(ncolors2-i)/float(ncolors2)
                               redVec[i] = (255)*frac
                               grnVec[i] = (255)*frac
                               bluVec[i] = (255)
                             endfor
                             for i=ncolors2+1,ncolors-1 do begin
                               frac = float(ncolors-i)/float(ncolors2)
                               redVec[i] = (255)
                               grnVec[i] = (255)*frac
                               bluVec[i] = (255)*frac
                             endfor

                             tvlct, redVec, grnVec, bluVec

                             plotter = self->get_plotter()
                             colors = plotter->get_drawcolors()
                             self.mydrawcolors = ptr_new(colors)
                             colors[0] = 'medium gray'
                             plotter->set_drawcolors, colors
                             plotter->focus
                             plotter->plot
                           end

        self.drawcolors_wid: BEGIN
           plotter = self->get_plotter()
           colorpicker = Obj_New('mgs_drawcolors', $
                                 colors=plotter->get_drawcolors(), $
                                 labeltext = [ 'background', $
                                               'titles', $
                                               'contours', $
                                               'overplot', $
                                               'colorbar', $
                                               'continents', $
                                               'grid', $
                                               'vectors',$
                                               'line plot',$
                                               'line oplot' ], $
                                 title='Select drawing colors')
           colorpicker->GUI, /block
           plotter->set_drawcolors, colorpicker->GetValue()
           Obj_Destroy, colorpicker
           plotter->focus
           plotter->plot
        END

        self.contour_wid: cm = obj_new('geov_plotter_contour_manager',self->get_plotter())

        self.unzoom_wid: BEGIN
                          plotter = self->get_plotter()
                          (plotter->get_zoomer())->unzoom
                          plotter->plot
                        END

        self.titles_wid: titles_editor = obj_new('geov_plotter_titles_editor',self->get_plotter())

        self.reset_axes_wid: BEGIN
                              plotter = self->get_plotter()
                              plotter->reset_axes_range
                              plotter->plot
                            END

        self.animate_wid: (self->get_plotter())->animate
        self.fanimate_wid: (self->get_plotter())->animate, /file

        self.new_window_wids[0]: ip=self.manager->create_plotter(self,  $
                                 (self.manager->get_preferences())->get_window_size('small') )
        self.new_window_wids[1]: ip=self.manager->create_plotter(self,  $
                                 (self.manager->get_preferences())->get_window_size('medium') )
        self.new_window_wids[2]: ip=self.manager->create_plotter(self,  $
                                 (self.manager->get_preferences())->get_window_size('large') )

        self.pvars_wid  : BEGIN
                         ; check at most two items selected
                          ipvars = self->get_ipvar()
                          if (n_elements(ipvars) gt 2) then begin
                              r=dialog_message('ERROR: AT MOST 2 VARIABLES CAN BE SELECTED')
                              ; select first index only
                              widget_control, self.pvars_wid, set_list_select=ipvars[0]
                          endif else begin

;                            self->reset_summation_op
                            ; if double selection, request same coordinate dependence
                            if (n_elements(ipvars) eq 2) then begin
                                pvbits= self.ncfiles->get_pvbits()
                                pvmasks = (*pvbits)[self->get_ipvar()]
                                if (pvmasks[0] ne pvmasks[1]) then begin
                                    r=dialog_message('ERROR: THE TWO VARIABLES SELECTED HAVE DIFFERENT DIMENSIONS')
                                    ; select first index only
                                    widget_control, self.pvars_wid, set_list_select=ipvars[0]
                                endif
                            endif
                            ; flag the very first plot (no plotter instantiated yet)
                            if (obj_valid(self.plotters[self.iplotter])) then changeit=0 else changeit=1
                            ok = self->check_plot_type(changeit=changeit)
                            self->activator, /lists, /plot_buttons, plot_is_valid=ok ; activate/deactivate lists and buttons
                            ; check for memory-stored contour edges
                  ;          if (ptr_valid((*self.edges)[ipvars[0]])) then begin
                  ;              self->set_auto_contour,0    ; update contour widget
                  ;          endif
                                ; if plot type is compatible with variable selection -> plot it


                            if (ok eq 1) then begin
                             (self->get_plotter())->main
                            endif
                                ; a bit of a kludg... activate again in case totcol_flag gets set
                            self->activator, /lists, /plot_buttons, plot_is_valid=ok ; activate/deactivate lists and buttons

                          endelse ; #ipvars<=2
                          END

        self.lats_wid : BEGIN
                          ; check at most two items selected
                          indexes = widget_info(self.lats_wid,/list_select)
                          if (n_elements(indexes) gt 2) then begin
                              r=dialog_message('ERROR: AT MOST 2 LATITUDES CAN BE SELECTED')
                              ; select first index only
                              widget_control, self.lats_wid, set_list_select=indexes[0]
                          endif else begin
;                              self->reset_summation_op
                              if (self.ptype eq MAP_GP) then (self->get_plotter())->import_map
                              (self->get_plotter())->main
                          endelse
                        END
        self.lons_wid : BEGIN
                          ; check at most two items selected
                          indexes = widget_info(self.lons_wid,/list_select)
                          if (n_elements(indexes) gt 2) then begin
                              r=dialog_message('ERROR: AT MOST 2 LONGITUDES CAN BE SELECTED')
                              ; select first index only
                              widget_control, self.lons_wid, set_list_select=indexes[0]
                          endif else begin
;                              self->reset_summation_op
                              if (self.ptype eq MAP_GP) then (self->get_plotter())->import_map
                              (self->get_plotter())->main
                          endelse
                        END
        self.levs_wid : BEGIN
                          ; check at most two items selected
                          indexes = widget_info(self.levs_wid,/list_select)
                          if (n_elements(indexes) gt 2) then begin
                              r=dialog_message('ERROR: AT MOST 2 LEVELS CAN BE SELECTED')
                              ; select first index only
                              widget_control, self.levs_wid, set_list_select=indexes[0]
                          endif else begin
;                               self->reset_summation_op
                              (self->get_plotter())->main
                          endelse
                        END
        self.times_wid : BEGIN
                          ; check at most two items selected
                          indexes = widget_info(self.times_wid,/list_select)
                          if (n_elements(indexes) gt 2) then begin
                              r=dialog_message('ERROR: AT MOST 2 TIMES CAN BE SELECTED')
                              ; select first index only
                              widget_control, self.levs_wid, set_list_select=indexes[0]
                          endif else begin
;                               self->reset_summation_op
                              (self->get_plotter())->main
                           endelse
                         END

        self.auto_contour_wid: BEGIN
                                 val = self->get_auto_contour()
                                 self->activator

                                 if (val eq 1) then begin
                                    self->set_edges, /free ; free edges for this plotting variable
                                 endif else begin
                                    self->import_edges
                                 endelse
                                 (self->get_plotter())->plot  ; replot
                               END

        self.auto_log_linear_wid: Begin
                                 (self->get_plotter())->import_all
                                 (self->get_plotter())->plot  ; replot
                                End

        self.scaling_wid: BEGIN
                            plotter = self->get_plotter()
                            plotter->set_scaling, event.value
                            plotter->main ; must reextract the data
                          END

        self.logp_wid: begin

                         self->set_levels_widget
                         logpval = self->get_levels_button_value()  

                         for i=0,MAXSCREENS-1 do begin
                           plotter = self.plotters[i]
                           if obj_valid(plotter) then begin
                             plotter->set_levs2_flag, logpval
                             plotter->plot
                           endif
                         endfor

                       end

        self.samescale_wid: begin
                         plotter = self->get_plotter()
                         plotter->set_oplot_samescale, event.select
                         plotter->plot
                       end

        self.uvwind_wid: BEGIN
                           plotter = self->get_plotter()
                           plotter->switch_uvwind_flag
                           plotter->plot
                        END


        self.operator_wid: BEGIN

                             (self->get_plotter())->main;,/noextractors ;must reextract the data

                             ; make widgets active/inactive
                             ; - needed here to set the plot options active/inactive
                             self->activator, /plot_buttons, /lists

                           END

        self.extractor_wid: BEGIN

                             self.show_sum_gui = 1

                             (self->get_plotter())->main;,/noextractors ;must reextract the data

                             ; make widgets active/inactive
                             ; - needed here to set the plot options active/inactive
                             self->activator, /plot_buttons, /lists

                           END

        self.close_wid: Begin
                          obj_destroy, self  ; commit suicide
                          HEAP_GC            ; garbage collect
                        End
        self.exit_wid: exit                ; exit from IDL


        self.open_wid: begin
                         widget_control, self.manager->get_base(),/show
                       end

        self.quit_wid: begin
                         Obj_Destroy, self.manager
                         return
                       end

        self.about_wid: begin
                          displayAboutInfo, event.top
                        end

        self.xtr_cntrls_button: begin
                                  self->toggel_xtr_cntrls

                                end


    ELSE: BEGIN
            ; check if print buttons event
            plotter = self->get_plotter()
            for i=0,n_elements(self.print_wids)-1 do begin
               if (event.id eq self.print_wids[i]) then begin
                  output = strlowcase(self.print_types[i])
                  ; choose orientation for postscript

                  if (output eq 'ps' or output eq 'eps') then begin
                      landscape = (self.manager->get_preferences())->get_ps_landscape()
                  endif else landscape = 0

                  if (output ne 'netcdf') then begin
                     pm = obj_new('print_manager', output, landscape=landscape,savepath=self.savepath, get_savepath=new_savepath)
                     self.savepath = new_savepath
                     ; check if user decided to abort
                     if (obj_valid(pm)) then begin
                        if (output eq 'ps' or output eq 'eps') then begin
                           ; must reload color table
                           cm = plotter->get_color_manager()
                           cm->reloadct
                           ; redraw plot to PS/EPS device
                           plotter->plot
                         endif
                         obj_destroy, pm
                      endif
                      return
                   endif

                  if (output eq 'netcdf') then begin
                      plotter->plot, /write_data
                  endif
               endif
            endfor


            ; check if plot buttons event
            for i=0, n_elements(*self.pbuttons_wid)-1 do begin
               if (event.id eq (*self.pbuttons_wid)[i]) then begin
;                 self->reset_summation_op
                 self->plot_buttons_event_listener, (*self.pbuttons_values)[i]
                 return
              endif
            endfor

            ; check if contour option event
            for i=0, n_elements(self.contour_opt_wids)-1 do begin
                if (event.id eq self.contour_opt_wids[i]) then begin
                    plotter = self->get_plotter();
                    plotter->set_contour_opt, i
                    plotter->plot
                    return
                endif
            endfor

            ; check if time-axis-type option event
            for i=0, n_elements(self.timeaxis_wids)-1 do begin
                if (event.id eq self.timeaxis_wids[i]) then begin
                    plotter = self->get_plotter();
                    plotter->set_timeaxistype, i
                    plotter->plot
                    return
                endif
            endfor

            ; check if format scale labels option event
            for i=0, n_elements(self.set_format_wids)-1 do begin
                if (event.id eq self.set_format_wids[i]) then begin
                    plotter = self->get_plotter();
                    plotter->set_scale_format, i
                    plotter->plot
                    return
                endif
            endfor

          END

    ENDCASE

  endelse ; selection event

END
