; method to choose default plot type according to variable selected
PRO geov_gui::choose_default_plot
    @geov_pars

    ; retrieve coordinate mask for current variable selection
    pvbits= self.ncfiles->get_pvbits()   ; coordinate bits for all plotting variables
    mask = ((*pvbits)[self->get_ipvar()])[0] ; use first selected variable

    ; try 2D plot first
    if (((mask and LONBIT) gt 0) and ( (mask and LATBIT) gt 0))      then ptype = LATvsLON $
    else if (((mask and LEVBIT) gt 0) and ( (mask and LATBIT) gt 0)) then ptype = LEVvsLAT $
    else if (((mask and LEVBIT) gt 0) and ( (mask and LONBIT) gt 0)) then ptype = LEVvsLON $
    else if ((mask and LATBIT) gt 0) then ptype = VARvsLAT $
    else if ((mask and LONBIT) gt 0) then ptype = VARvsLON $
    else if ((mask and LEVBIT) gt 0) then ptype = LEVvsVAR $
    else if ((mask and TIMBIT) gt 0) then ptype = VARvsTIM

    self->set_plot, ptype

END
