;method to check that variable selection is compatible with current plot type
FUNCTION geov_gui::check_plot_type, changeit=changeit
    @geov_pars

    ; retrieve coordinate mask for current variable selection
    pvbits= self.ncfiles->get_pvbits()   ; coordinate bits for all plotting variables
    mask = ((*pvbits)[self->get_ipvar()])[0] ; use first variable selected

    ; turn off levels dependence if total column density is selected
    if (self.totcol_flag ne 0) then begin
      mask = mask and (not LEVBIT)
    endif

   ; check that plot type is compatible with variable selected
   pstruct = geov_get_bit_struct(self.ptype)

   ; X axis requested for lat, lon, lev or time but plotting variable does not have that coordinate
   if (   ((pstruct.xbit ne VARBIT) and ((pstruct.xbit and mask) eq 0))  $

   ; Y axis requested for lat, lon, lev or time but plotting variable does not have that coordinate
       or ((pstruct.ybit ne VARBIT) and ((pstruct.ybit and mask) eq 0))  $

   ; user requested averaging on some coordinate but variable does not depend on that coordinate
       or ((pstruct.avebit gt 0) and ((pstruct.avebit and mask) eq 0))  $

   ; user requested variable at constant pressure but it does not depend on pressure
       or ((pstruct.cnstprsbit gt 0) and ((pstruct.cnstprsbit and mask) eq 0)) ) then begin

         if (keyword_set(changeit)) then begin

             self->choose_default_plot
             return, 1

         endif else begin

             result = dialog_message(['VARIABLE SELECTION IS INCOMPATIBLE WITH PLOT TYPE.', $
                                      'PLEASE SELECT ANOTHER PLOT TYPE OR ANOTHER VARIBLE'])
             return, 0
         endelse

    endif

    return, 1 ; plot is valid

END
