FUNCTION geov_extractor::compute_total_tracer_mass, mmr, delp, gw, dlambda

  Re = 6350e3 ; m
  g = 9.8 ; m/s^2
  pi = 3.1415928

  sz = size(mmr)

  imax = sz[1]
  jmax = sz[2]
  kmax = sz[3]

  tmass = 0.0
  tmass2 = 0.0


;  for i=0, imax-1 do begin
;    for j=0, jmax-1 do begin
;      for k=0, kmax-1 do begin
;        tmass = tmass + mmr[i,j,k]*delp[i,j,k]*gw[j]*dlambda[j]*(pi/180.)*Re^2/g
;      endfor
;    endfor
;  endfor

  for i=0, imax-1 do begin
      for k=0, kmax-1 do begin
        tmass2 = tmass2 + total(mmr[i,*,k]*delp[i,*,k]*gw[*]*dlambda[*]*(pi/180.)*Re^2/g)
      endfor
  endfor

  return, tmass2*1.e-9

END

Function geov_extractor::retrieve_guass_weights, offset, count
  ; get the file id
  fid = self.ncfiles->get_fid()

  ; get the variable id and check that T exists in the netCDF file
  varid = NCDF_VARID( fid, 'gw' )
  if ( varid eq -1 ) then varid = NCDF_VARID( fid, 'gws' ) 
  if ( varid eq -1 ) then varid = NCDF_VARID( fid, 'GW' ) 
  if ( varid eq -1 ) then begin
     message,'not able to find gw variable in the netCDF file !!!'
     return, -1
  endif

  ; extract the temperature field from the netCDF file
  gws = *(self.ncfiles->get_data( varid, offset, count ))

  return, gws
End

Function geov_extractor::retrieve_delps, offset, count
  ; get the file id
  fid = self.ncfiles->get_fid()

  ; get the variable id and check that T exists in the netCDF file
  varid = NCDF_VARID( fid, 'PDELDRY' )
  if ( varid eq -1 ) then varid = NCDF_VARID( fid, 'delpdry' ) 
  if ( varid eq -1 ) then begin
     message,'Not able to find delp variable in the netCDF file !!!'
     return, -1
  endif

  ; extract the temperature field from the netCDF file
  dps = *(self.ncfiles->get_data( varid, offset, count ))

  return, dps
End

Function geov_extractor::retrieve_dlambdas, offset, count
  ; get the file id
  fid = self.ncfiles->get_fid()

  ; get the variable id and check that T exists in the netCDF file
  varid = NCDF_VARID( fid, 'lat' )
  if ( varid eq -1 ) then varid = NCDF_VARID( fid, 'latitude' )  
  if ( varid eq -1 ) then begin
     message,'not able to find latitude variable in the netCDF file !!!'
     return, -1
  endif

  ; extract the temperature field from the netCDF file
  lats = self.ncfiles->get_data( varid, offset, count )

  lats_minus = shift(*lats,1)

  dlambdas =  (*lats) - lats_minus

  dlambdas[0] = (*lats)[1] - (*lats)[0]

  return, dlambdas
End

Function geov_extractor::tracer_mass

  ; check that the units of the current field is 'MMR'
  vunits = self.ncfiles->get_vunits()
  units = (*vunits)[self.vid]
  if ( (STRCMP( units, 'MMR', 3,/fold_case ) eq 0)       and $
       (STRCMP( units, 'kg/kg', 8,/fold_case ) eq 0) and $
       (STRCMP( units, 'g/g', 8,/fold_case ) eq 0)   ) then begin
    message,'The variable has incorrect units for the number density calculation'
    return, -1
  endif

  dsizes = self.ncfiles->get_dsizes()

  res = self->variable_dimensions(self.vid)

  ilat = res.latdim
  ilon = res.londim
  ilev = res.levdim
  itim = res.timdim

  lat_did = self.ncfiles->get_dimid_of_var( ilat, self.vid )
  lon_did = self.ncfiles->get_dimid_of_var( ilon, self.vid )
  lev_did = self.ncfiles->get_dimid_of_var( ilev, self.vid )
  tim_did = self.ncfiles->get_dimid_of_var( itim, self.vid )

  nlats = (*dsizes)[lat_did]
  nlons = (*dsizes)[lon_did]
  nlevs = (*dsizes)[lev_did]
  ntims = (*dsizes)[tim_did]

  offset = intarr(4)
  count = intarr(4)

  offset[*] = 0

  count[ilat] = nlats
  count[ilon] = nlons
  count[ilev] = nlevs
  count[itim] = 1

  gws = self->retrieve_guass_weights([0],[nlats])
  dlambdas = self->retrieve_dlambdas([0],[nlats])

  mass = fltarr(ntims)

  for tim_ind =0, ntims-1 do begin

    offset[itim] = tim_ind
  
    delps = self->retrieve_delps( offset, count )

    mmr = *( self.ncfiles->get_data( self.vid, offset, count ) )

    mass[tim_ind] = self->compute_total_tracer_mass( mmr, delps, gws, dlambdas )

   if (tim_ind gt 0) then print,'diff mass = ',mass[tim_ind]-mass[tim_ind-1]

  endfor

  return, ptr_new(mass)

End
