FUNCTION geov_extractor::init, gui, ncfiles
  @geov_pars

  ; precompile access methods
  self->get
  self->set
  self->import

  ; store reference to associated objects
  self.gui = gui
  self.ncfiles = ncfiles

  ; look up altitude variable
  self.alt_vid = ncfiles->get_vid('Z3GM')
  if (self.alt_vid lt 1) then begin
     self.alt_vid = ncfiles->get_vid('Z3')
     self.alt_adj = (self.alt_vid gt 0)
  endif
  
  ; allocate memory
  ncoords = ncfiles->get_ncoords()
  self.icoords = ptr_new(lonarr(ncoords))
  self.actions = ptr_new(lonarr(ncoords))

  ; set default scaling factor (for scaling of VMR to ppm, ppb, ppt)
  self.scale_factor = 1.

  self.colflag = gui->get_totcol_flag()
  self.numflag = gui->get_numden_flag()
  self.tmassflag = gui->get_tmass_flag()

  return, 1
END
