function extract_anomaly, vid, idim, counts, offsets, dsizes

  u = extract(vid,counts,offsets)

  adj_offs = offsets
  adj_cnts = counts

  adj_offs[idim] = 0
  adj_cnts[idim] = dsizes[idim]

  x = extract(vid, adj_cnts, adj_offs)

  u_ave = total(x, idim+1)/dsizes[idim]

  ref_arr = [1,1,1,1,1]
  for i = 0, n_elements(counts)-1 do ref_arr[i]=counts[i]

  ave_ref_arr = [1,1,1,1,1]
  for i = 0, n_elements(counts)-1 do ave_ref_arr[i]=adj_cnts[i]

  u = reform(u,ref_arr)
  u_ave = reform(u_ave,ave_ref_arr)

  ix = lonarr(10)

  for k=1, n_elements(counts)-1 do begin
    ik = k*2+1
    ix[ik] = counts[k]
  endfor 

  jx = ix
  anomaly = u

  for dim=0, counts[idim] do begin

    ix[idim*2] = dim
    ix[idim*2+1] = dim
    jx[idim*2] = 0
    jx[idim*2+1] = 0

    anomaly[ix[0]:ix[1],ix[2]:ix[3],ix[4]:ix[5],ix[6]:ix[7],ix[8]:ix[9]] = &
          u[ix[0]:ix[1],ix[2]:ix[3],ix[4]:ix[5],ix[6]:ix[7],ix[8]:ix[9]] - &
          a[jx[0]:jx[1],jx[2]:jx[3],jx[4]:jx[5],jx[6]:jx[7],jx[8]:jx[9]]
  
  endfor

  return, anomaly

end
