program MOP02_test


      IMPLICIT NONE

      include 'Toolkit.f'
      include 'hdfeos5.inc'
      include 'hdfeos5_64.inc'


      integer :: fid, swid, sdid, ierr
      integer*8 :: dimsize, nprs2
      integer*8 :: count(1), start(1), stride(1)
      integer*8 :: count2(2), start2(2), stride2(2)

      real :: press(10)
      real :: matrix(10,10)

      integer :: he5_swopen, he5_swcreate, he5_swdefdim, he5_swdefgfld, &
                 he5_swdefdfld, he5_swdefdimscale, he5_swsetdimscale, he5_swwrfld, &
                 he5_swdetach, he5_swclose

      DATA press/1000.,900.,800.,700.,600.,500.,400.,300.,200.,100./

      ierr = 0
      fid  = -1
      swid = -1
      sdid = -1

      !----------create file & dimension---------------------------------
      fid = he5_swopen("MOP02.test.he5", HE5F_ACC_TRUNC)
      swid = he5_swcreate(fid, "MOP02")

      dimsize = 10
      ierr = he5_swdefdim(swid, 'nPrs', dimsize)

      !------------geo-fields------------------------------------
      ierr = he5_swdefgfld(swid, "Pressure", "nPrs", " ", HE5T_NATIVE_FLOAT,0)

      !-------------data fields-----------------------------------
      ierr = he5_swdefdfld(swid, "PressureGrid", "nPrs", " ", HE5T_NATIVE_FLOAT, 0)
      ierr = he5_swdefdfld(swid, "TestMatrix", "nPrs,nPrs", " ", HE5T_NATIVE_FLOAT, 0)
      !ierr = he5_swdefdfld(swid, "TestMatrix", "nPrs,nPrs", "nPrs,nPrs", HE5T_NATIVE_FLOAT, 0)


      !---------dim scale-------------------------
      nprs2 = 10
      ierr = he5_swdefdimscale(swid, 'nPrs', nprs2, HE5T_NATIVE_FLOAT, press)


      ! ---- write some const fields ----- 
      start(1) = 0
      stride(1) = 1
      count(1) = nprs2
      ierr = he5_swwrfld(swid, "PressureGrid", start, stride, count, press)
      ierr = he5_swwrfld(swid, "Pressure", start, stride, count, press)

      start2(1) = 0
      start2(2) = 0
      stride2(:) = 1
      count2(1) = 10
      count2(2) = 10
      ierr = he5_swwrfld(swid, "TestMatrix", start2, stride2, count2, matrix)

      !---------close file-------------------------
      ierr = he5_swdetach(swid)
      ierr = he5_swclose(fid)


end program MOP02_test
