#******************************************************************************
# BOXMOX dilution case
# Christoph Knote - 12/2017
#******************************************************************************

dat <- read.csv("MOZART_T1.conc", header=TRUE, sep="")

speccols <- c(NO2="green", CH2O="yellow", O3="blue", CO="red")

dat[names(dat) != "time"] <- dat[names(dat) != "time"]
#dat$time <- dat$time

png(file="dilution.png", width=7, height=4, units="in", res=144)
par(mar=c(4,2.75,2.5,2.75), mgp=c(2,1,0))
plot(dat$time, dat$CO, type="l", ylim=c(0, max(dat$CO)), xlab="time (h)",
    ylab="", xaxs="i", yaxs="i", axes=FALSE, col=speccols["CO"],
    main="Dilution by tracer concentration")
scaler <- 10
lines(dat$time, dat$NO2*scaler,  col=speccols["NO2"])
lines(dat$time, dat$CH2O*scaler, col=speccols["CH2O"])
lines(dat$time, dat$O3*scaler,   col=speccols["O3"])

legend("top", cex=0.8, legend=c(
        "CO", "CH2O", "NO2", "O3"), lwd=1, lty=1,
    col=speccols[c("CO", "CH2O", "NO2", "O3")], bty="n",
    ncol=5, xpd=NA, inset=-0.0)

mtext(side=3, line=0.25, adj=-0.1, text=expression(CO~(ppmv)))
mtext(side=3, line=0.25, adj=1.1,  text=expression(others~(ppbv)))

axis(1, at=seq(0, max(dat$time), by=1))
axis(2, las=2)
axis(4, at=axTicks(2), labels=axTicks(2)/scaler, las=2)

dev.off()
