#!/bin/sh

export WRF_EM_CORE=1
export WRF_NMM_CORE=0
export WRF_CHEM=1
export WRF_KPP=1
export WRFIO_NCD_LARGE_FILE_SUPPORT=1
#export NETCDF4=1

# yellowstone
module load ncl
export YACC='/usr/bin/yacc -d'
export FLEX_LIB_DIR='/glade/u/home/knote/intel/lib'

# acd-knote + amadeus
export YACC='/usr/bin/yacc -d'
export FLEX_LIB_DIR='/usr/lib64'
export NETCDF='/home/knote'
export NETCDF_DIR=$NETCDF
export JASPERLIB=/home/knote/lib
export JASPERINC=/home/knote/include
# for WPS: lg2c -> /usr/lib64/libg2c.so.0.0.0

#####################################################
# Mac
#####################################################

remove malloc.h
ch WGRIB to WGRIB_
remove linear tree optimization

chem/KPP/util/write_decomp/Makefile -> integr_edit.exe to ./integr_edit.exe


# debug flags
# PGI
-C -g -gopt -v -Mbounds -Mchkfpstk -Mchkptr -Mchkstk -Mdepchk \
-Ktrap=fp -traceback -Minform=inform -Mlist -Minfo=all -Mneginfo -Wl,-zmuldefs \
-Meh_frame


# pp of output to get totoa

for aFile in $(ls -1 wrfout*)
do 
    ncap2 -A -s "Time[\$Time]=array(1,1,\$Time);bottom_top[\$bottom_top]=array(1,1,\$bottom_top);south_north[\$south_north]=array(1,1,\$south_north);west_east[\$west_east]=array(1,1,\$west_east);totoa_a01=smpa_a01+smpbb_a01+glysoa_a01+biog1_c_a01+biog1_o_a01+oc_a01;totoa_a02=smpa_a02+smpbb_a02+glysoa_a02+biog1_c_a02+biog1_o_a02+oc_a02;totoa_a03=smpa_a03+smpbb_a03+glysoa_a03+biog1_c_a03+biog1_o_a03+oc_a03;totoa_a04=smpa_a04+smpbb_a04+glysoa_a04+biog1_c_a04+biog1_o_a04+oc_a04;" ${aFile} ${aFile}
done














